% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_stress.R, R/layouts.R
\name{layout_stress}
\alias{layout_stress}
\alias{layout_with_stress}
\alias{layout_igraph_stress}
\title{stress majorization layout}
\usage{
layout_with_stress(
  g,
  weights = NA,
  iter = 500,
  tol = 1e-04,
  mds = TRUE,
  bbox = 30
)

layout_igraph_stress(
  g,
  weights = NA,
  iter = 500,
  tol = 1e-04,
  mds = TRUE,
  bbox = 30,
  circular
)
}
\arguments{
\item{g}{igraph object}

\item{weights}{possibly a numeric vector with edge weights. If this is NULL and the graph has a weight edge attribute, then the attribute is used. If this is NA then no weights are used (even if the graph has a weight attribute). By default, weights are ignored. See details for more.}

\item{iter}{number of iterations during stress optimization}

\item{tol}{stopping criterion for stress optimization}

\item{mds}{should an MDS layout be used as initial layout (default: TRUE)}

\item{bbox}{width of layout. Only relevant to determine the placement of disconnected graphs}

\item{circular}{not used}
}
\value{
matrix of xy coordinates
}
\description{
force-directed graph layout based on stress majorization.
}
\details{
Be careful when using weights. In most cases, the inverse of the edge weights should be used to ensure that the endpoints of an edges with higher weights are closer together (weights=1/E(g)$weight).

The layout_igraph_* function should not be used directly. It is only used as an argument for plotting with 'igraph'.
'ggraph' natively supports the layout.
}
\examples{
library(igraph)
library(ggraph)
set.seed(665)

g <- sample_pa(100, 1, 1, directed = FALSE)

# calculate layout manually
xy <- layout_with_stress(g)

# use it with ggraph
\dontrun{
ggraph(g, layout = "stress") +
  geom_edge_link0(edge_width = 0.2, colour = "grey") +
  geom_node_point(col = "black", size = 0.3) +
  theme_graph()
}
}
\references{
Gansner, E. R., Koren, Y., & North, S. (2004). Graph drawing by stress majorization. \emph{In International Symposium on Graph Drawing} (pp. 239-250). Springer, Berlin, Heidelberg.
}
\seealso{
\link{layout_stress3D}
}
