% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Seizures}
\alias{Seizures}
\title{Seizures}
\format{
A data frame with 236 rows and 6 variables:
\describe{
  \item{seizures}{a numeric vector indicating the number of epileptic seizures.}
  \item{treatment}{a factor indicating the applied treatment: "Progabide" and "Placebo".}
  \item{base}{a numeric vector indicating the number of epileptic seizures in the baseline eight-week inverval.}
  \item{age}{a numeric vector indicating the age of the individuals.}
  \item{time}{a numeric vector indicating which the two-week interval corresponds to the reported number of epileptic seizures.}
  \item{id}{a numeric vector indicating the identifier of each individual.}
}
}
\source{
Thall P.F., Vail S.C. (1990) Some covariance models for longitudinal count data with overdispersion. \emph{Biometrics} 46:657–671.
}
\usage{
data(Seizures)
}
\description{
The dataset reports the number of epileptic seizures in each
of four two-week intervals, and in a baseline eight-week inverval, for
Progabide treatment and placebo groups with a total of 59 individuals.
}
\examples{
dev.new()
data(Seizures)
boxplot(seizures ~ treatment:time, data=Seizures, ylim=c(0,25), col=c("blue","yellow"))
}
\references{
Carey V.J., Wang Y.-G. (2011) Working covariance model selection for generalized estimating equations. \emph{Statistics in Medicine} 30:3117–3124.

Fu L., Hao Y., Wang Y.-G. (2018) Working correlation structure selection in generalized estimating equations. \emph{Computational Statistics & Data Analysis} 33:983–996.

Diggle P.J., Liang K.Y., Zeger S.L. (1994, page 166) \emph{Analysis of Longitudinal Data}. Clarendon Press.
}
\keyword{datasets}
