% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Cortisol}
\alias{Cortisol}
\title{Radioimmunological Assay of Cortisol}
\format{
A data frame with 64 rows and 2 variables:
\describe{
  \item{lDose}{a numeric vector indicating the logarithm in base 10 of the dose.}
  \item{Y}{a numeric vector indicating the response, in counts per minute.}
}
}
\usage{
data(Cortisol)
}
\description{
The amount of hormone contained in a preparation
cannot be measured directly, so estimating an unknown dose of
hormone involves a two-step process. A calibration curve must
first be established, then the curve must be inverted to
determine the hormone dose. The calibration curve is estimated
using a radioimmunological assay.
}
\examples{
data(Cortisol)
dev.new()
with(Cortisol, plot(lDose,Y,xlab="Log10(Dose, in ng/0.1 ml)",pch=16,col="blue",
                    ylab="Response, in counts per minute"))
}
\references{
Huet S., Bouvier A., Poursat M.-A., Jolivet E. (2004). \emph{Statistical tools for nonlinear regression : a practical guide with S-PLUS and R
examples. 2nd Edition}. Springer,  New York.
}
\keyword{datasets}
