% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stateface.r
\name{geom_stateface}
\alias{geom_stateface}
\title{Use ProPublica's StateFace font in ggplot2 plots}
\usage{
geom_stateface(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", ..., parse = FALSE, nudge_x = 0, nudge_y = 0,
  check_overlap = FALSE, na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{parse}{If TRUE, the labels will be parsed into expressions and
displayed as described in ?plotmath}

\item{nudge_x, nudge_y}{Horizontal and vertical adjustment to nudge l
abels by. Useful for offsetting text from points, particularly
on discrete scales.}

\item{check_overlap}{If \code{TRUE}, text that overlaps previous text in the
same layer will not be plotted.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}
}
\description{
The \code{label} parameter can be either a 2-letter state abbreviation
or a full state name. \code{geom_stateface()} will take care of the
translation to StateFace font glyph characters.
}
\details{
The package will also take care of loading the StateFace font for
PDF and other devices, but to use it with the on-screen ggplot2
device, you'll need to install the font on your system.

\code{ggalt} ships with a copy of the StateFace TTF font. You can
run \code{show_stateface()} to get the filesystem location and then
load the font manually from there.

\if{html}{
A sample of the output from \code{geom_stateface()}:

\figure{geomstateface01.png}{options: width="100\%" alt="Figure: geomstateface01.png"}
}

\if{latex}{
A sample of the output from \code{geom_stateface()}:

\figure{geomstateface01.png}{options: width=10cm}
}
}
\examples{
\dontrun{
library(ggplot2)
library(ggalt)

# Run show_stateface() to see the location of the TTF StateFace font
# You need to install it for it to work

set.seed(1492)
dat <- data.frame(state=state.abb,
                  x=sample(100, 50),
                  y=sample(100, 50),
                  col=sample(c("#b2182b", "#2166ac"), 50, replace=TRUE),
                  sz=sample(6:15, 50, replace=TRUE),
                  stringsAsFactors=FALSE)
gg <- ggplot(dat, aes(x=x, y=y))
gg <- gg + geom_stateface(aes(label=state, color=col, size=sz))
gg <- gg + scale_color_identity()
gg <- gg + scale_size_identity()
gg
}
}
\seealso{
Other StateFace operations: \code{\link{load_stateface}},
  \code{\link{show_stateface}}
}
