% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_dumbbell.R
\name{geom_dumbbell}
\alias{geom_dumbbell}
\title{Dumbell charts}
\usage{
geom_dumbbell(mapping = NULL, data = NULL, ..., colour_x = NULL,
  size_x = NULL, colour_xend = NULL, size_xend = NULL,
  dot_guide = FALSE, dot_guide_size = NULL, dot_guide_colour = NULL,
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{colour_x}{the colour of the start point}

\item{size_x}{the size of the start point}

\item{colour_xend}{the colour of the end point}

\item{size_xend}{the size of the end point}

\item{dot_guide}{if \code{TRUE}, a leading dotted line will be placed before the left-most dumbbell point}

\item{dot_guide_size, dot_guide_colour}{singe-value aesthetics for \code{dot_guide}}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}
}
\description{
The dumbbell geom is used to create dumbbell charts.
}
\details{
Dumbbell dot plots — dot plots with two or more series of data — are an
alternative to the clustered bar chart or slope graph.
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggplot2:::rd_aesthetics("geom", "segment")}
}

\examples{
library(ggplot2)

df <- data.frame(trt=LETTERS[1:5], l=c(20, 40, 10, 30, 50), r=c(70, 50, 30, 60, 80))

ggplot(df, aes(y=trt, x=l, xend=r)) +
  geom_dumbbell(size=3, color="#e3e2e1",
                colour_x = "#5b8124", colour_xend = "#bad744",
                dot_guide=TRUE, dot_guide_size=0.25) +
  labs(x=NULL, y=NULL, title="ggplot2 geom_dumbbell with dot guide") +
  theme_minimal() +
  theme(panel.grid.major.x=element_line(size=0.05))
}
