% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{var_labels<-}
\alias{var_labels<-}
\title{Set label attributes of all variables in a \code{data.frame}}
\usage{
var_labels(x) <- value
}
\arguments{
\item{x}{(\code{data.frame})\cr a data frame object.}

\item{value}{(\code{character})\cr a vector of new variable labels. If any values are \code{NA},
the label for that variable is removed.}
}
\value{
\code{x} with modified variable labels.
}
\description{
Variable labels can be stored as the \code{label} attribute for each variable.
This functions sets all non-missing (non-\code{NA}) variable labels in a \code{data.frame}.
}
\examples{
x <- iris
var_labels(x)
var_labels(x) <- paste("label for", names(iris))
var_labels(x)

if (interactive()) {
  View(x) # in RStudio data viewer labels are displayed
}

}
