% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/page_size.R
\name{page_lcpp}
\alias{page_lcpp}
\title{Determine lines per page (LPP) and characters per page (CPP) based on font and page type}
\usage{
page_lcpp(
  page_type = page_types(),
  landscape = FALSE,
  font_family = "Courier",
  font_size = 8,
  lineheight = 1,
  margins = c(top = 0.5, bottom = 0.5, left = 0.75, right = 0.75),
  pg_width = NULL,
  pg_height = NULL
)
}
\arguments{
\item{page_type}{(\code{string})\cr name of a page type. See \code{\link{page_types}}. Ignored
when \code{pg_width} and \code{pg_height} are set directly.}

\item{landscape}{(\code{flag})\cr whether the dimensions of \code{page_type} should be
inverted for landscape orientation. Defaults to \code{FALSE}, ignored when \code{pg_width} and
\code{pg_height} are set directly.}

\item{font_family}{(\code{string})\cr name of a font family. An error will be thrown
if the family named is not monospaced. Defaults to \code{"Courier"}.}

\item{font_size}{(\code{numeric(1)})\cr font size. Defaults to \code{12}.}

\item{lineheight}{(\code{numeric(1)})\cr line height. Defaults to \code{1}.}

\item{margins}{(\code{numeric(4)})\cr named numeric vector containing \code{"bottom"}, \code{"left"},
\code{"top"}, and \code{"right"} margins in inches. Defaults to \code{.5} inches for both vertical
margins and \code{.75} for both horizontal margins.}

\item{pg_width}{(\code{numeric(1)})\cr page width in inches.}

\item{pg_height}{(\code{numeric(1)})\cr page height in inches.}
}
\value{
A named list containing LPP (lines per page) and CPP (characters per page)
elements suitable for use by the pagination machinery.
}
\description{
Determine lines per page (LPP) and characters per page (CPP) based on font and page type
}
\examples{
page_lcpp()
page_lcpp(font_size = 10)
page_lcpp("a4", font_size = 10)

page_lcpp(margins = c(top = 1, bottom = 1, left = 1, right = 1))
page_lcpp(pg_width = 10, pg_height = 15)

}
