% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvalue.R
\name{pvalue}
\alias{pvalue}
\title{Bayesian P-Value}
\usage{
pvalue(x, threshold = 0, na_rm = FALSE)
}
\arguments{
\item{x}{A numeric vector of MCMC values.}

\item{threshold}{A number of the threshold value.}

\item{na_rm}{A flag specifying whether to remove missing values.}
}
\value{
A number between 0 and 1.
}
\description{
A Bayesian p-value (p) is here defined in terms of the quantile-based
(1-p) * 100\% credible interval (CRI) that
just includes a threshold (Kery and Schaub 2011).
By default a p-value of 0.05 indicates that the 95\% CRI just includes 0.
}
\examples{
pvalue(as.numeric(0:100))
}
\references{
Kery, M., and Schaub, M. 2011.
Bayesian population analysis using WinBUGS: a hierarchical perspective.
Academic Press, Boston. Available from \url{https://www.vogelwarte.ch/de/projekte/publikationen/bpa/}.
}
\seealso{
Other summary: 
\code{\link{kurtosis}()},
\code{\link{lower}()},
\code{\link{pzeros}()},
\code{\link{skewness}()},
\code{\link{svalue}()},
\code{\link{upper}()},
\code{\link{variance}()},
\code{\link{xtr_mean}()},
\code{\link{xtr_median}()},
\code{\link{xtr_sd}()},
\code{\link{zeros}()},
\code{\link{zscore}()}
}
\concept{summary}
