<!-- Generated by galley: do not edit by hand -->

This vignette describes the logic behind the names of the
{dm}-functions.

In general the functions are implemented in such a way, that no function
can handle both `dm` classes (`dm` and `dm_zoomed`) as an argument. A
`dm_zoomed` behaves in most situations like a table and there are mostly
no explicit functions available for this class, but rather methods (see
vignette [“Zooming and manipulating
tables”](https://cynkra.github.io/dm/articles/tech-dm-zoom.html).

## Prefixes

1.  `dm_`: There are two cases for this prefix:
    -   The function takes a `dm` object as a first argument
    -   The function constructs a `dm` object from other objects
2.  `check_`: Certain tests on the arguments are performed and an error
    is thrown in case they are not passed. If the tests are passed, the
    first argument is returned invisibly.
3.  `examine_`: The function executes checks and returns an object
    containing an overview of the results of the checks.

Most important extended prefixes `dm_..._`:

1.  `dm_examine_`: The function examines several aspects of a `dm`
    object
2.  `dm_add_`: Adds either key constraints or new tables to a `dm`
3.  `dm_get_`: Retrieves a specific piece of information about the `dm`
    (often a part of its constituents)
4.  `dm_rm_`: Removes either key constraints or tables from a `dm`

## Suffixes

1.  `_dm`: Validators, checkers or coercers
2.  `_to_tbl`: Data from a `dm` is processed in a way that a tibble is
    produced
3.  `_candidates`: If key-candidates are to be calculated and presented
    in tibble-form
4.  `_pk(s)`: Relates to primary key
5.  `_fk(s)`: Relates to foreign key
6.  `_tbl`: Add/remove/select/rename a tibble to/from/within a dm
7.  `_colors`: Relates to the colors for the visualization of the dm
8.  `_zoomed`: Insert, update or discard the zoomed table. In
    combination with the prefix `dm_` this indicates, that the first
    argument is a `dm_zoomed` rather than a `dm`.
