% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/defm_mle.R
\name{logodds}
\alias{logodds}
\alias{defm_mle}
\alias{summary_table}
\title{Maximum Likelihood Estimation of DEFM}
\usage{
logodds(m, par, i, j)

defm_mle(object, start, lower, upper, ...)

summary_table(object, as_texreg = FALSE, ...)
}
\arguments{
\item{m}{An object of class \link{DEFM}.}

\item{par}{The parameters of the model.}

\item{i, j}{The row and column of the array to turn on for the log odds.}

\item{object}{An object of class \link{DEFM}.}

\item{start}{Double vector. Starting point for the MLE.}

\item{lower, upper}{Lower and upper limits for the optimization (passed to
\link[stats4:mle]{stats4::mle}.)}

\item{...}{Further arguments passed to \link[stats4:mle]{stats4::mle}.}

\item{as_texreg}{When \code{TRUE}, wraps the result in a texreg object}
}
\value{
\itemize{
\item \code{logodds} returns a numeric vector with the log-odds for each observation in the data.
}

An object of class \link[stats4:mle]{stats4::mle}.
}
\description{
Fits a Discrete Exponential-Family Model using Maximum Likelihood.
}
\details{
The likelihood function of the DEFM is closely-related to the
Exponential-Family Random Graph Model [ERGM]. Furthermore, the DEFM can
be treated as a generalization of the ERGM. The model implemented here
can be viewed as an ERGM for a bipartite network, where the actors are
individuals and the events are the binary outputs.

If the model features no markov terms, i.e., terms that depend on more than
one output, then the model is equivalent to a logistic regression. The
example below shows this equivalence.

The function \code{summary_table} computes pvalues and returns a table
with the estimates, se, and pvalues. If \code{as_texreg = TRUE}, then it will
return a texreg object.
}
\examples{
#' Using Valente's SNS data
data(valentesnsList)

# Creating the DEFM object
logit_0 <- new_defm(
  id = valentesnsList$id,
  X = valentesnsList$X,
  Y = valentesnsList$Y[,1,drop=FALSE],
  order = 0
)

# Building the model
term_defm_logit_intercept(logit_0)
term_defm_logit_intercept(logit_0, idx = "Hispanic")
term_defm_logit_intercept(
 logit_0, idx = "exposure_smoke",
 vname = "Smoke Exp"
)
term_defm_logit_intercept(logit_0, idx = "Grades")
init_defm(logit_0) # Needs to be initialized

# Fitting the model
res_0 <- defm_mle(logit_0)

# Refitting the model using GLM
res_glm <- with(
  valentesnsList,
  glm(Y[,1] ~ X[,1] + X[,3] + X[,7], family = binomial())
  )

# Comparing results
summary_table(res_0)
summary(res_glm)

# Comparing the logodds
head(logodds(logit_0, par = coef(res_0), i = 0, j = 0))

}
\references{
Vega Yon, G. G., Pugh, M. J., & Valente, T. W. (2022). Discrete Exponential-Family Models for Multivariate Binary Outcomes (arXiv:2211.00627). arXiv. \url{https://arxiv.org/abs/2211.00627}
}
\seealso{
\link{DEFM} for objects of class DEFM and \code{\link[=loglike_defm]{loglike_defm()}} for the
log-likelihood function of DEFMs.
}
