% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columnar_transposition.R
\name{columnar_transposition}
\alias{columnar_transposition}
\title{Columnar Transposition Cipher}
\usage{
columnar_transposition(message, key, encrypt = TRUE)
}
\arguments{
\item{message}{A character vector}

\item{key}{A character vector composed only of a-zA-Z letters used as the encryption key}

\item{encrypt}{(Default: \code{TRUE}) TRUE will encrypt the message, while FALSE will decrypt the message.}
}
\value{
A character vector of either plaintext that has been encrypted or ciphertext that has been decrypted
using the columnar transposition cryptographic method.
}
\description{
This can be used to encrypt or decrypt a Columnar Transposition cipher.
This method is a development of the Scytale cipher that rearranges the encryption matrix used in the
Scytale method by the alphabetical ordering of the encryption key.
}
\examples{
columnar_transposition("Hidden message", "hack", encrypt = TRUE)
columnar_transposition("insed sHeegdma", "hack", encrypt = FALSE)

}
