% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crawl-package.R
\docType{data}
\name{harborSeal_sf}
\alias{harborSeal_sf}
\title{Harbor seal location data updated since Johnson et al. (2008)}
\format{
A Simple Feature Collection with 7059 features and 3 fields.

\describe{ 
\item{Time}{a numeric vector.}
\item{DryTime}{a numeric vector.}
\item{Argos_loc_class}{a factor with levels \code{0} \code{1}
\code{2} \code{3} \code{A} \code{B}.}
\item{geometry}{a list column with geometry data; CRS = EPSG:4326}
}
}
\source{
Marine Mammal Laboratory, Alaska
Fisheries Science Center, National Marine Fisheries Service, NOAA 7600 Sand
Point Way NE Seattle, WA 98115
}
\description{
The original location data used in Johnson et al. (2008) was geographic
(latitude/longitude) (but not explicitly documented) and provided as a 
simple data frame. This data updates the data to a Simple Feature
Collection (as part of the \href{https://r-spatial.github.io/sf/articles/}{sf} 
package) with the CRS explicitly set.
}
\references{
Johnson, D., J. London, M. -A. Lea, and J. Durban (2008)
Continuous-time random walk model for animal telemetry data. Ecology
89:1208-1215.
}
\author{
Josh M. London
}
\keyword{data}
\keyword{sets}
