% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runif3.R
\name{runif3}
\alias{runif3}
\title{Generate randomly oriented vectors in 3D}
\usage{
runif3(
  n = 1,
  r = c(0, 1),
  azimuth = c(0, 2 * pi),
  polarangle = c(0, pi),
  quasi = FALSE,
  start = 1
)
}
\arguments{
\item{n}{number of random vectors to be generated}

\item{r}{2-vector specifying the range of radii}

\item{azimuth}{2-vector specifying the range of azimuth angles (maximum range 0..2*pi)}

\item{polarangle}{2-vector specifying the range of polar angles (maximum range 0..pi)}

\item{quasi}{logical flag. If true, quasi-random numbers with low-discrepancy are drawn, based on a Halton sequence. Otherwise, the standard internal pseudo-random generator of \code{runif()} is used.}

\item{start}{starting index of Halton sequence. Only used if \code{quasi=TRUE}.}
}
\value{
Returns an n-by-3 array of n vectors.
}
\description{
Generate randomly oriented vectors in 3D, following an isotropic distribution (optionally truncated to a region).
}
\examples{
## draw 20 unit vectors on a sphere
x = runif3(20,r=c(1,1))
print(rowSums(x^2))

}
\seealso{
\code{\link{runif2}}
}
\author{
Danail Obreschkow
}
