% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histcoord.R
\name{histcoord}
\alias{histcoord}
\title{Generate histogram coordinates from mid points}
\usage{
histcoord(x, y, yleft = 0, yright = 0)
}
\arguments{
\item{x}{n-vector giving the bin mid-points}

\item{y}{n-vector giving bin values}

\item{yleft}{optional value specifying the value at the left edge}

\item{yright}{optional value specifying the value at the right edge}
}
\value{
(2n+2)-by-2 matrix of (x,y)-coordinates to draw histogram as a connected line
}
\description{
Converts the mid-point x-values and mean densities of binned data into (x,y)-coordinates of a histogram.
}
\examples{
x = seq(5)
y = sin(x)
plot(x,y,xlim=c(0,6))
lines(histcoord(x,y))

}
\author{
Danail Obreschkow
}
