% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conogive.R
\name{reliability}
\alias{reliability}
\alias{ordinal_r}
\alias{theoretical_ordinal_r}
\alias{theoretical_ordinal_alpha}
\title{Calculate the Ordinal Reliabiltiy}
\usage{
ordinal_r(
  object,
  xi = c("sample", "theoretical"),
  weights = c("optimal", "equal")
)

theoretical_ordinal_r(object, weights = c("optimal", "equal", "sigma"))

theoretical_ordinal_alpha(object)
}
\arguments{
\item{object}{An object of class \code{conogive}.}

\item{xi}{How to calculate the Xi matrix. Option \code{"theoretical"} calculates
the theoretical Xi matrix from \code{rho}, while  \code{"sample"} calculates the
sample Xi matrix.}

\item{weights}{The weights used to calculate the ordinal reliability.
Option \code{"optimal"} uses the optimal weights and \code{"equal"} the equal
weights.}
}
\value{
The concrete ordinal reliability, theoretical ordinal reliability, or
theoretical ordinal alpha.
}
\description{
The function \code{ordinal_r } calculates the concrete ordinal reliability.
The functions \code{theoretical_ordinal_r} and \code{theoretical_ordinal_alpha}
calculates the theoretical ordinal reliability and alpha based on the
polychoric correlation matrix.
}
\details{
The population value of theoretical ordinal alpha equals the theoretical
ordinal reliability when the underlying multivariate normal is parallel.
The concrete ordinal reliability is the sqaured correlation between the
true latent variable and the best linear predictor of the observed
Likert-type data. See ((ref)) for definitions.
}
\examples{
if(require("psychTools")) {
  agreeableness = psychTools::bfi[c("A1", "A2", "A3", "A4", "A5")]
  agreeableness[, "A1"] = 7 - agreeableness[, "A1"] # Reverse-coded item.
  object = conogive(agreeableness)
  ordinal_r(object, weights = "equal") # 0.6394087
  theoretical_ordinal_alpha(object) # 0.7589922
  theoretical_ordinal_r(object, weights = "equal") # 0.7689878
  ordinal_r(object, weights = "optimal") # 0.6763742
  theoretical_ordinal_r(object) # 0.8101108
}
}
