% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apsimx_filetype.R
\name{apsimx_filetype}
\alias{apsimx_filetype}
\title{Test file format for .apsimx files}
\usage{
apsimx_filetype(file = "", src.dir = ".")
}
\arguments{
\item{file}{file ending in .apsimx to be tested}

\item{src.dir}{directory containing the .apsimx file to be tested; defaults to the current working directory}
}
\value{
\sQuote{xml}, \sQuote{json} or \sQuote{unknown}
}
\description{
Test whether an .apsimx file is XML or json
}
\note{
Minimal function which reads only the first line in a file and tries to guess whether it is
      an \sQuote{xml} or \sQuote{json} file type.
}
\examples{
\donttest{
extd.dir <- system.file("extdata", package = "apsimx")
apsimx_filetype("Wheat.apsimx", src.dir = extd.dir) 
}

}
