% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factors.R
\name{15. Factorization}
\alias{15. Factorization}
\alias{factors}
\alias{factors.default}
\alias{factors.numeric}
\alias{factors.vli}
\title{Factorization of vli Objects}
\usage{
factors(n, iter = 10, output = "print")

\method{factors}{default}(n, iter = 10, output = "print")

\method{factors}{numeric}(n, iter = 10, output = "print")

\method{factors}{vli}(n, iter = 10, output = "print")
}
\arguments{
\item{n}{integer to be factorized; vli class object or 32 bits integer}

\item{iter}{number of iterations for testing if the given number is prime; numeric}

\item{output}{chosen way for objects being returned: \code{'list'} to return the result as a list of vli objects or \code{'print'} (by default) to simply display the result on the screen; character}
}
\value{
list of objects of class vli or the result displayed on the screen, depending on the \code{output} argument
}
\description{
\code{factors} returns all the prime factors of a given number.
}
\details{
The implemented algorithm is based in a Monte Carlo method for integer factorization called Pollard's Rho Algorithm.

It determines if the given number is prime or composite by usign the Miller-Rabin Probabilistic Primality Test. If it is prime, it returns the number itself. If it is composite, it calls iteratively the \code{divisor} function until all the prime factors of the given number are found.

It is a Monte Carlo method, therefore it is not deterministic. The number of iterations is configurable, to set the desired accuracy. A too low number of iterations could cause an infinite loop because of being looking for a divisor of a prime number.
}
\examples{
x <- as.vli("584843")
factors(x, iter = 100)
}
\author{
Javier Leiva Cuadrado
}
