% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genericFunctions.R
\name{empiricalParameters}
\alias{empiricalParameters}
\title{Calculate empirical parameters}
\usage{
empiricalParameters(y, ...)
}
\arguments{
\item{y}{output of rtrunc}

\item{...}{other arguments passed to methods}
}
\value{
A vector of parameter estimates for the input sample
}
\description{
Returns the empirical parameter estimate for a distribution
}
\examples{
# Normal distribution
sampNorm <- rtrunc(50, mean = 5, sd = 2)
empiricalParameters(sampNorm)

# Poisson distribution
sampPois <- rtrunc(10, lambda = 100, family = "Poisson")
empiricalParameters(sampPois)
}
