#' @title Truncated Exponential Family
#' @description TruncExpFam is an R package to handle truncated members from the
#' exponential family.
#' @docType package
#' @name TruncExpFam
#' @details This package offers truncated versions of popular distribution
#' functions from the stats package, as well as functions to retrieve the
#' original distribution parameters from a truncated sample. For more info,
#' please check [rtrunc()], [dtrunc()] and [print.trunc()].
#' @section Supported distributions:
#' \itemize{
#'  \item Beta
#'  \item Binomial
#'  \item Chi-Square
#'  \item Continuous Bernoulli
#'  \item Exponential
#'  \item Gamma
#'  \item Inverse Gamma
#'  \item Inverse Gaussian
#'  \item Log-normal
#'  \item Negative Binomial
#'  \item Normal
#'  \item Poisson
#' }
#' @note Found a bug? Want to suggest a feature? Contribute to the scientific
#' and open source communities by opening an issue on our home page.
#' Check the "BugReports" field on \code{packageDescription("TruncExpFam")} for
#' the URL.
"_PACKAGE"
