% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_stat.R
\name{boot_stat}
\alias{boot_stat}
\title{Compute the bootstrap test statistic for parallel implementation}
\usage{
boot_stat(u, Y_tilde, X, D, epsilon, N3, p, prec, N, sample_mat,
  generalized, weights, y_grid, phi_n, M_bar, DX)
}
\arguments{
\item{u}{bootstrap index;}

\item{Y_tilde}{the vector stacking the realisations y then the anticipated values psi of respective sizes n_y and n_p.}

\item{X}{the matrix of covariates.  Set to a vector of 1 by default (in which case the test without covariates is performed).}

\item{D}{the vector stacking the dummies for the dataset of realisation : n_y ones then n_p zeros}

\item{epsilon}{the parameter epsilonon in  Section 3 of DGM. Default value is 0.05.}

\item{N3}{equals to N if covariates, to 1 other wise.}

\item{p}{the parameter p in  Section 3 of DGM.  Default is  0.05.}

\item{prec}{the number of points to be tested. Default is 30.}

\item{N}{the total numeber of obs}

\item{sample_mat}{matrix of bootrap indexes}

\item{generalized}{"Add" if additive shocks for the generalized test}

\item{weights}{survey weights}

\item{y_grid}{the grid points. Default is quantile(Y_tilde,seq(0,1,length.out=30)).}

\item{phi_n}{the GMS function in DGM}

\item{M_bar}{the quantilty bar m in section 2 of  DGM}

\item{DX}{the total number of covariates}
}
\description{
This is an internal function to separately compute the bootsrap test statsitic.
}
\details{
By default, the test is implemented without covariates. To perform the test with covariates, one has to indicate in X a non-constant vector or matrix. Also, one can perform the « generalized » tests allowing for aggregate shocks by using the dummy variable generalized. Survey weights can be added. The user can modify the number of cores used by R to reduce the computational time. Tuning parameters used in the test can also be modified.
}
