% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findbeta_panel.r
\name{findbeta_panel}
\alias{findbeta_panel}
\title{The findbeta (panel) function}
\usage{
findbeta_panel(themean.vec=NULL, themedian.vec=NULL,
 themode.vec=NULL, seed=280385, nsims=10000)
}
\arguments{
\item{themean.vec}{specify your prior belief about the mean. It takes a vector of means, with values between 0 and 1. Not to be specified if a vector has been given for the median or the mode.}

\item{themedian.vec}{specify your prior belief about the median. It takes a vector of medians, with values between 0 and 1. Not to be specified if a vector has been given for the mean or the mode.}

\item{themode.vec}{specify your prior belief about the mode. It takes a vector of modes, with values between 0 and 1. Not to be specified if a vector has been given for the mean or the median.}

\item{seed}{A fixed seed for replication purposes.}

\item{nsims}{Number of simulations for the creation of various summary metrics of the elicited prior.}
}
\value{
parameters: The beta distribution parameters Beta(a,b)

summary: A basic summary of the elicited prior

input: The initial input value that produced the above prior.
}
\description{
A function to estimate the parameters alpha and beta of a Beta distribution based on the existing prior beliefs (data and/or expert opinion).
Information should be provided about the mean (or the median or the mode) as a vector corresponding to multiple prior mean prevalences from experts or studies.
}
\examples{
## Example 1
## Based on the available literature the median/mean/mode value for the specificity of a
## test is expected to be equal to 0.1, 0.2, 0.4, 0.04, 0.01, 0.5 based on opinions of 6 experts.

resmed <- findbeta_panel(themedian.vec = c(0.1, 0.2, 0.4, 0.04, 0.01, 0.5))
resmed

resmea <- findbeta_panel(themean.vec = c(0.1, 0.2, 0.4, 0.04, 0.01, 0.5))
resmea

resmod <- findbeta_panel(themode.vec = c(0.1, 0.2, 0.4, 0.04, 0.01, 0.5))
resmod

plot(resmed, lty = 1)
lines(resmea, lty = 2)
lines(resmod, lty = 3)
}
\references{
Branscum, A. J., Gardner, I. A., & Johnson, W. O. (2005): Estimation of diagnostic test sensitivity and specificity through Bayesian modeling. Preventive veterinary medicine, \bold{68}, 145--163.
}
