% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nevilles_algorithm.R
\name{neville}
\alias{neville}
\alias{lagrange}
\title{Lagrange Interpolation Polynomials}
\usage{
neville(x, y, x0 = polynomial())

lagrange(x, y, x0 = polynomial())
}
\arguments{
\item{x}{A numeric vector of x-values}

\item{y}{A numeric values of y-values corresponding to the x-values}

\item{x0}{Either a polynomial object or a vector of x-values for which
interpolated y-values are required.}
}
\value{
Either an interpolation polynomial object or a vector of interpolated y-values
}
\description{
Compute the Lagrange Interpolation Polynomial from a given set of x- and y-values,
or, alterntively, compute the interpolated values at a set of given x-values.
Two algorithms are provided, namely Neville's algorithm, or a more direct version
based on the usual Lagrange formula.  The latter is generally faster but the former
can be more accurate numerically.
}
\examples{

set.seed(123)
x <- 1:5
y <- rnorm(x)
xout <- 0.5 + 1:4

p1 <- neville(x, y)
plot(p1, xlim = range(x), ylim = extendrange(y, f = 1), panel.first = grid())
points(x, y, col = 4)
points(xout, lagrange(x, y, xout), col = 2)
}
