% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.matrix.R
\name{model.matrix.lmm}
\alias{model.matrix.lmm}
\title{Design Matrix for Linear Mixed Model}
\usage{
\method{model.matrix}{lmm}(
  object,
  newdata = NULL,
  effects = "mean",
  simplify = TRUE,
  drop.X = NULL,
  na.rm = TRUE,
  ...
)
}
\arguments{
\item{object}{an lmm object}

\item{newdata}{[data.frame] dataset relative to which the design matrix should be constructed.}

\item{effects}{[character] design matrix relative to the mean model (\code{"mean"}), variance model (\code{"variance"}), correlation model (\code{"correlation"}),
or all the previous (\code{"all"}).
Can also be \code{"index"} to only output the normalize data and the cluster, time, strata indexes.}

\item{simplify}{[logical] simplify the data format of the output (matrix instead of a list of matrix) when possible.}

\item{drop.X}{[logical] when the design matrix does not have full rank, should columns be dropped?}

\item{na.rm}{[logical] Should row containing missing values for the variables used in the linear mixed model be removed?}

\item{...}{Not used. For compatibility with the generic method.}
}
\value{
When \code{simplify} is \code{FALSE}, a list with the followin elements: \itemize{
\item \code{mean}: design matrix for the mean model
\item \code{Y}: vector of outcome values
\item \code{vcov}: list of elements for the variance and correlation models.
\item \code{index.cluster}: list containing, for each cluster, the location of the corresponding observations in the processed dataset.
\item \code{index.clusterTime}: list containing, for each cluster, the repetition index corresponding observations.
\item \code{index.clusterStrata}: list containing, for each cluster, the strata index corresponding observations.
\item \code{param}: data.frame describing the modle parameters.
\item \code{drop.X}: logical value indicating whether columns in the design matrix should be dropped if it has not full rank.
\item \code{precompute.XX}, \code{precompute.XY}: moments of X and Y 
}

When \code{simplify} is \code{TRUE}, this list will be simplified into a list with three elements: \itemize{
\item \code{mean}: design matrix for the mean model
\item \code{variance}: design matrix for the variance model
\item \code{correlation}: design matrix for the correlation model
}
or a single design matrixx.
}
\description{
Extract or construct design matrices for Linear Mixed Model.
}
\keyword{methods}
