% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.R
\name{fitted.lmm}
\alias{fitted.lmm}
\title{Predicted Mean Value For Linear Mixed Model.}
\usage{
\method{fitted}{lmm}(
  object,
  newdata = NULL,
  type = "mean",
  se = NULL,
  df = NULL,
  keep.data = NULL,
  format = "long",
  seed = NULL,
  simplify = TRUE,
  ...
)
}
\arguments{
\item{object}{a \code{lmm} object.}

\item{newdata}{[data.frame] the covariate values for each cluster.}

\item{type}{[character] By default fitted values are output (\code{NULL}).
Can also output the expected outcome (for missing outcomes) based on covariates and other outcome values from the same cluster (\code{"impute"}),
the change or expected change between baseline and each follow-up (\code{"change"}),
or the area under the curve of the outcome (\code{"auc"}, require a numeric repetition variable).}

\item{se}{[character] passed to \code{predict.lmm} to evaluate the standard error of the fitted value, expected outcome, change in expected outcome, or area under the curve.}

\item{df}{[logical] should a Student's t-distribution be used to model the distribution of the predicted mean. Otherwise a normal distribution is used.}

\item{keep.data}{[logical] Should the dataset relative to which the predictions are evaluated be output along side the predicted values?
Only possible in the long format.}

\item{format}{[character] Should the prediction be output
in a matrix format with clusters in row and timepoints in columns (\code{"wide"}),
or in a data.frame/vector with as many rows as observations (\code{"long"})}

\item{seed}{[integer, >0] Random number generator (RNG) state used when starting imputation. If NULL no state is set.}

\item{simplify}{[logical] Simplify the data format (vector instead of data.frame) and column names (no mention of the time variable) when possible.}

\item{...}{Additional argument passed the \code{\link{predict.lmm}}.}
}
\value{
When \code{format="wide"}, a data.frame with as many rows as clusters.
When \code{format="long"}, a data.frame with as many rows as observations (\code{keep.data==TRUE})
or a vector of length the number of observations (\code{keep.data==TRUE}).
}
\description{
Evaluate the expected mean conditional to covariates or the expected outcome values when missing conditional to observed outcome and covariates.
Similar to \code{\link{predict.lmm}} where the values to condition on are, by default, taking from the dataset used to fit the Linear Mixed Model.
}
\examples{
#### single arm trial ####
data(gastricbypassL, package = "LMMstar")
gastricbypassL <- gastricbypassL[order(gastricbypassL$id,gastricbypassL$visit),]
gastricbypassL$weight0 <- unlist(tapply(gastricbypassL$weight,gastricbypassL$id,
function(x){rep(x[1],length(x))}))

eUN.lmm <- lmm(glucagonAUC ~ visit + weight0, repetition = ~visit|id,
               data = gastricbypassL, df = FALSE)

## fitted mean (conditional on covariates only)
fitted(eUN.lmm)
fitted(eUN.lmm, newdata = data.frame(visit = "3", weight0 = 0))
fitted(eUN.lmm, newdata = data.frame(visit = "3", weight0 = 0),
       keep.data = TRUE)

## fitted outcome value (conditional on covariates and covariates)
fitted(eUN.lmm, type = "outcome")
gastricbypassL.O <- fitted(eUN.lmm, type = "outcome", keep.data = TRUE)

if(require(ggplot2)){
gg.outcome <- ggplot(gastricbypassL.O,
                     aes(x=time, y = glucagonAUC, color = impute, group = id))
gg.outcome <- gg.outcome + geom_point() + geom_line()## + facet_wrap(~id)
gg.outcome
}

tapply(gastricbypassL.O$glucagonAUC, gastricbypassL.O$time, mean)
effects(eUN.lmm, variable = NULL)

## fitted change value (conditional on covariates and covariates)
gastricbypassL.C <- fitted(eUN.lmm, type = "change", keep.data = TRUE)

if(require(ggplot2)){
gg.change <- ggplot(gastricbypassL.C,
                    aes(x=time, y = glucagonAUC, color = impute, group = id))
gg.change <- gg.change + geom_point() + geom_line()
gg.change
}

tapply(gastricbypassL.C$glucagonAUC, gastricbypassL.O$time, mean)
effects(eUN.lmm, type = "change", variable = NULL)

## fitted auc (conditional on covariates and covariates)
gastricbypassL.AUC <- fitted(eUN.lmm, type = "auc", keep.data = TRUE)

if(require(ggplot2)){
gg.auc <- ggplot(gastricbypassL.AUC,
                    aes(x = "auc", y = glucagonAUC, color = impute))
gg.auc <- gg.auc + geom_point()
gg.auc
}

mean(gastricbypassL.AUC$glucagonAUC)
effects(eUN.lmm, type = "auc", variable = NULL)

#### two arm trial ####
\dontrun{
if(require(nlmeU) & require(reshape2)){
data(armd.wide, package = "nlmeU")
armd.long <- melt(armd.wide,
                  measure.vars = paste0("visual",c(0,4,12,24,52)),
                  id.var = c("subject","lesion","treat.f","miss.pat"),
                  variable.name = "week",
                  value.name = "visual")

armd.long$week <- factor(armd.long$week, 
                         level = paste0("visual",c(0,4,12,24,52)),
                         labels = c(0,4,12,24,52))

eUN2.lmm <- lmm(visual ~ treat.f*week + lesion,
               repetition = ~week|subject, structure = "UN",
               data = armd.long)

## fitted outcome value (conditional on covariates and covariates)
armd.O <- fitted(eUN2.lmm, type = "outcome", keep.data = TRUE)

gg2.outcome <- ggplot(armd.O,
                     aes(x=week, y = visual, color = impute, group = subject))
gg2.outcome <- gg2.outcome + geom_point() + geom_line() + facet_wrap(~treat.f)
gg2.outcome

aggregate(visual ~ week + treat.f, FUN = mean, data = armd.O)
effects(eUN2.lmm, variable = "treat.f") ## mismatch due to adjustment on lesion

## fitted change value (conditional on covariates and covariates)
armd.C <- fitted(eUN2.lmm, type = "change", keep.data = TRUE)

gg.change <- ggplot(armd.C,
                    aes(x=week, y = visual, color = impute, group = subject))
gg.change <- gg.change + geom_point() + geom_line() + facet_wrap(~treat.f)
gg.change

coef(eUN2.lmm)
effects(eUN2.lmm, type = "change", variable = "treat.f")
effects(eUN2.lmm, type = c("change","difference"), variable = "treat.f")

## fitted auc (conditional on covariates and covariates)
armd.AUC <- fitted(eUN2.lmm, type = "auc", keep.data = TRUE)

gg.auc <- ggplot(armd.AUC, aes(x = treat.f, y = visual, color = impute))
gg.auc <- gg.auc + geom_point()
gg.auc

aggregate(visual ~ treat.f, data = armd.AUC, FUN = "mean")
effects(eUN2.lmm, type = "auc", variable = "treat.f") ## adjusted for lesion
effects(eUN2.lmm, type = c("auc","difference"), variable = "treat.f")
}}
}
\keyword{methods}
