% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure.R
\name{CUSTOM}
\alias{CUSTOM}
\title{Custom Structure}
\usage{
CUSTOM(
  formula,
  var.cluster,
  var.time,
  FCT.sigma,
  dFCT.sigma = NULL,
  d2FCT.sigma = NULL,
  init.sigma,
  FCT.rho,
  dFCT.rho = NULL,
  d2FCT.rho = NULL,
  init.rho,
  add.time
)
}
\arguments{
\item{formula}{formula indicating variables influencing the residual variance and correlation (right hand side).}

\item{var.cluster}{[character] cluster variable.}

\item{var.time}{[character] time variable.}

\item{FCT.sigma}{[function] take as argument the model parameters, time, and design matrix.
Output the vector of residuals standard deviations.}

\item{dFCT.sigma}{[list of vectors] list whose elements are the first derivative of argument \code{FCT.sigma}.}

\item{d2FCT.sigma}{[list of vectors] list whose elements are the second derivative of argument \code{FCT.sigma} (no cross-terms).}

\item{init.sigma}{[numeric vector] initial value for the variance parameters.}

\item{FCT.rho}{[function] take as argument the model parameters, time, and design matrix.
Output the matrix of residuals correlation.}

\item{dFCT.rho}{[list of matrices] list whose elements are the first derivative of argument \code{FCT.rho}.}

\item{d2FCT.rho}{[list of matrices] list whose elements are the second derivative of argument \code{FCT.rho} (no cross-terms).}

\item{init.rho}{[numeric vector] initial value for the correlation parameters.}

\item{add.time}{not used.}
}
\value{
An object of class \code{CUSTOM} that can be passed to the argument \code{structure} of the \code{lmm} function.
}
\description{
Variance-covariance structure specified by the user.
}
\examples{

## Compound symmetry structure
CUSTOM(~1,
       FCT.sigma = function(p,n.time,X){rep(p,n.time)},
       init.sigma = c("sigma"=1),
       dFCT.sigma = function(p,n.time,X){list(sigma = rep(1,n.time))},  
       d2FCT.sigma = function(p,n.time,X){list(sigma = rep(0,n.time))},  
       FCT.rho = function(p,n.time,X){
           matrix(p,n.time,n.time)+diag(1-p,n.time,n.time)
       },
       init.rho = c("rho"=0.5),
       dFCT.rho = function(p,n.time,X){
            list(rho = matrix(1,n.time,n.time)-diag(1,n.time,n.time))
       },
       d2FCT.rho = function(p,n.time,X){list(rho = matrix(0,n.time,n.time))}
)

## 2 block structure
rho.2block <- function(p,n.time,X){
   rho <- matrix(0, nrow = n.time, ncol = n.time)
   rho[1,2] <- rho[2,1] <- rho[4,5] <- rho[5,4] <- p["rho1"]
   rho[1,3] <- rho[3,1] <- rho[4,6] <- rho[6,4] <- p["rho2"]
   rho[2,3] <- rho[3,2] <- rho[5,6] <- rho[6,5] <- p["rho3"]
   rho[4:6,1:3] <- rho[1:3,4:6] <- p["rho4"]
   return(rho)
}
drho.2block <- function(p,n.time,X){
   drho <- list(rho1 = matrix(0, nrow = n.time, ncol = n.time),
                rho2 = matrix(0, nrow = n.time, ncol = n.time),
                rho3 = matrix(0, nrow = n.time, ncol = n.time),
                rho4 = matrix(0, nrow = n.time, ncol = n.time))   
   drho$rho1[1,2] <- drho$rho1[2,1] <- drho$rho1[4,5] <- drho$rho1[5,4] <- 1
   drho$rho2[1,3] <- drho$rho2[3,1] <- drho$rho2[4,6] <- drho$rho2[6,4] <- 1
   drho$rho3[2,3] <- drho$rho3[3,2] <- drho$rho3[5,6] <- drho$rho3[6,5] <- 1
   drho$rho4[4:6,1:3] <- drho$rho4[1:3,4:6] <- 1
   return(drho)
}
d2rho.2block <- function(p,n.time,X){
   d2rho <- list(rho1 = matrix(0, nrow = n.time, ncol = n.time),
                 rho2 = matrix(0, nrow = n.time, ncol = n.time),
                 rho3 = matrix(0, nrow = n.time, ncol = n.time),
                 rho4 = matrix(0, nrow = n.time, ncol = n.time))   
   return(d2rho)
}

CUSTOM(~variable,
       FCT.sigma = function(p,n.time,X){rep(p,n.time)},
       dFCT.sigma = function(p,n.time,X){list(sigma=rep(1,n.time))},
       d2FCT.sigma = function(p,n.time,X){list(sigma=rep(0,n.time))},
       init.sigma = c("sigma"=1),
       FCT.rho = rho.2block,
       dFCT.rho = drho.2block,
       d2FCT.rho = d2rho.2block,
       init.rho = c("rho1"=0.25,"rho2"=0.25,"rho3"=0.25,"rho4"=0.25))

}
\keyword{multivariate}
