\name{predict.groupbn}
\alias{predict.groupbn}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{predict.groupbn
%%  ~~function to do ... ~~
}
\description{
Predict the target variable from a group Bayesian network
}
\usage{
\method{predict}{groupbn}(object, X.quanti, X.quali, rename.level=FALSE, return.data=FALSE,
new.fit=FALSE, debug=FALSE, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{An object of class groupbn generated by the functions groupbn or groupbn_refinement
%%     ~~Describe \code{x} here~~
}
\item{X.quanti}{quantitative variables}
\item{X.quali}{qualitative variables}
\item{rename.level}{a boolean; if TRUE, all levels of categorical variables are renamed by integers. Default is FALSE.}
\item{return.data}{a boolean; if TRUE, a list with predictions and group.data is returned instead of only predicitions. Default is FALSE.}
\item{new.fit}{a boolean; if TRUE, the parameters are newly fit using the test data.}
\item{debug}{a boolean,
  if TRUE, debugging messages are printed}
\item{...}{further arguments}
}
\value{
Returns a dataframe with a column of predictions and a column of the target data. If the target is discrete, class probabilities are returned. Otherwise continuous scores are returned. If return.data is TRUE, additionally the transformed group data are returned.
}
\author{Ann-Kristin Becker
%%  ~~who you are~~
}
\examples{
#load example data
data(wine)
wine.test<-wine[wine$Soil\%in\%c("Reference", "Env1"),1:29]
wine.test$Soil<-factor(wine.test$Soil)
levels(wine.test$Soil)<-c("0", "1")

data(wine.groupbn.refined)
predict(wine.groupbn.refined, X.quanti=wine.test[,3:29], X.quali=wine.test[,1:2])
}
