#' World Happiness Report data
#'
#' The \code{happiness_train} and \code{happiness_test} datasets are generated
#' based on the "World Happiness Report" at Kaggle \url{https://www.kaggle.com/datasets/unsdsn/world-happiness}.
#'
#' It contains data for 781 countries and 7 variables. These are:
#' \itemize{
#' \item score - Happiness score
#' \item gdp_per_capita -  GDP per capita
#' \item social_support - Social support
#' \item healthy_life_expectancy - Healthy life expectancy
#' \item freedom_life_choices - Freedom to make life choices
#' \item generosity - Generosity
#' \item perceptions_of_corruption - Perceptions of corruption
#' }
#'
#' @docType data
#' @keywords happiness_test happiness_train
#' @name happiness
#' @aliases happiness_test happiness_train
#'
#' @source World Happiness Report data \url{https://worldhappiness.report/}
#' @usage
#' data(happiness_train)
#' data(happiness_test)
#' @format two data frames with total 781 rows, 7 columns ech and rownames
NULL

