#' @title Wangler et al. (2017)
#' 
#' @description A metabolomic map of Zellweger spectrum disorders reveals 
#' novel disease biomarkers. Global metabolic profiling obtained by 
#' untargetedmass spectrometry-based metabolomic platform for the 
#' detectionof novel and known inborn errors of metabolism.  This 
#' untargeted approach collected z-score values for >650 unique compounds 
#' fromhuman plasma.  Data set contains 19 individual plasma samples with
#' confirmed biallelic pathogenic variants in the PEX1 gene. These 
#' samples revealed elevations in pipecolic acid and long-chain
#' lysophosphatidylcholines, as well as an unanticipated reduction
#' in multiple sphingomyelin species.
#'
#' @name Wangler2017
#' @aliases Wangler2017
#' @docType data
#' @usage data(Wangler2017)
#' @format Wangler2017 - The data matrix (metabolite features are
#' rows, patient observations are columns) for 19 untargeted metabolomics 
#' patient samples, alongside metabolite annotations.
#' @keywords datasets
#' @references M.F. Wangler, et al. (2018). A metabolomic map of Zellweger 
#' spectrum disorders reveals novel disease biomarkers. Genetics in 
#' Medicine, 20: 1274-1283. <doi:10.1038/gim.2017.262>
#' @source Electronic supplementary material, Supplementary Tables
#' (\href{https://tinyurl.com/y4zus9l2}{Dataset})
#' @examples
#' data(Wangler2017)
"Wangler2017"
