% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/githubUtils.R
\name{githubURLParts}
\alias{githubURLParts}
\title{Extract GitHub user and repo name from GitHub URL}
\usage{
githubURLParts(urls)
}
\arguments{
\item{urls}{A \code{character()} vector of URLs}
}
\value{
A \code{data.frame} with four columns:
\itemize{
\item{url}{The original GitHub URL}
\item{user_repo}{The GitHub "username/repo", combined}
\item{user}{The GitHub username}
\item{repo}{The GitHub repo name}
}
}
\description{
Extract GitHub user and repo name from GitHub URL
}
\examples{
# find GitHub URL details for
# Bioconductor packages
bpkgl = biocPkgList()
urldetails = githubURLParts(bpkgl$URL)
urldetails = urldetails[!is.na(urldetails$url),]
head(urldetails)

}
