% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biocPkgList.R
\name{biocPkgList}
\alias{biocPkgList}
\title{Get full Bioconductor software package listing, with details}
\usage{
biocPkgList(
  version = BiocManager::version(),
  repo = "BioCsoft",
  addBiocViewParents = TRUE
)
}
\arguments{
\item{version}{The requested Bioconductor version. Will
default to use the BiocManager defaults (i.e., \code{version()}).}

\item{repo}{The requested Bioconductor repository. The default will be the
Bioconductor software repository: BioCsoft. Available repos include:
"BioCsoft", "BioCann", "BioCexp", "BioCworkflows", and "CRAN". Note
that not all repos are available for all versions, particularly older
versions (but who would use those, right?).}

\item{addBiocViewParents}{logical(), whether to add all biocViews
parents to biocViews annotations.}
}
\value{
An object of class \code{tbl_df}.
}
\description{
The BiocViews-generated \code{VIEWS} file is available
for Bioconductor release and devel repositories. It
contains quite a bit more information from the
package \code{DESCRIPTION} files than the \code{PACKAGES}
file. In particular, it contains \code{biocViews} annotations
and URLs for vignettes and developer URLs.
}
\details{
Since packages are annotated with the most specific
views, the default functionality here is to add parent terms
for all views for each package. For example, in the bioCsoft
repository, all packages will have at least "Software" added
to their biocViews. If one wants to stick to only the most
specific terms, set \code{addBiocViewParents} to \code{FALSE}.
}
\examples{
bpkgl = biocPkgList()
bpkgl
unlist(bpkgl[1,'Depends'])

# Get a list of all packages that
# import "GEOquery"
library(dplyr)
bpkgl \%>\%
  filter(Package=='GEOquery') \%>\%
  pull(c('importsMe'))

}
