% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JAGS-formula.R
\name{parameter_names}
\alias{parameter_names}
\alias{format_parameter_names}
\alias{JAGS_parameter_names}
\title{Clean parameter names from JAGS}
\usage{
format_parameter_names(
  parameters,
  formula_parameters = NULL,
  formula_prefix = TRUE
)

JAGS_parameter_names(parameters, formula_parameter = NULL)
}
\arguments{
\item{parameters}{a vector of parameter names}

\item{formula_parameters}{a vector of formula parameter prefix names}

\item{formula_prefix}{whether the \code{formula_parameters} names should be
kept. Defaults to \code{TRUE}.}

\item{formula_parameter}{a formula parameter prefix name}
}
\value{
A character vector with reformatted parameter names.
}
\description{
Removes additional formatting from parameter names outputted from
JAGS.
}
\examples{
format_parameter_names(c("mu_x_cont", "mu_x_fac3t", "mu_x_fac3t__xXx__x_cont"),
                       formula_parameters = "mu")

}
