% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JAGS-diagnostics.R
\name{JAGS_diagnostics}
\alias{JAGS_diagnostics}
\alias{JAGS_diagnostics_density}
\alias{JAGS_diagnostics_autocorrelation}
\alias{JAGS_diagnostics_trace}
\title{Plot diagnostics of a 'JAGS' model}
\usage{
JAGS_diagnostics(
  fit,
  parameter,
  type,
  plot_type = "base",
  xlim = NULL,
  ylim = NULL,
  lags = 30,
  n_points = 1000,
  transformations = NULL,
  transform_orthonormal = FALSE,
  short_name = FALSE,
  parameter_names = FALSE,
  formula_prefix = TRUE,
  ...
)

JAGS_diagnostics_density(
  fit,
  parameter,
  plot_type = "base",
  xlim = NULL,
  n_points = 1000,
  transformations = NULL,
  transform_orthonormal = FALSE,
  short_name = FALSE,
  parameter_names = FALSE,
  formula_prefix = TRUE,
  ...
)

JAGS_diagnostics_trace(
  fit,
  parameter,
  plot_type = "base",
  ylim = NULL,
  transformations = NULL,
  transform_orthonormal = FALSE,
  short_name = FALSE,
  parameter_names = FALSE,
  formula_prefix = TRUE,
  ...
)

JAGS_diagnostics_autocorrelation(
  fit,
  parameter,
  plot_type = "base",
  lags = 30,
  transformations = NULL,
  transform_orthonormal = FALSE,
  short_name = FALSE,
  parameter_names = FALSE,
  formula_prefix = TRUE,
  ...
)
}
\arguments{
\item{fit}{a JAGS model fitted via \code{\link[=JAGS_fit]{JAGS_fit()}}}

\item{parameter}{parameter to be plotted}

\item{type}{what type of model diagnostic should be plotted. The available
options are \code{"density"}, \code{"trace"}, and \code{"autocorrelation"}}

\item{plot_type}{whether to use a base plot \code{"base"}
or ggplot2 \code{"ggplot"} for plotting.}

\item{xlim}{x plotting range}

\item{ylim}{y plotting range}

\item{lags}{number of lags to be shown for the autocorrelation plot.
Defaults to \code{30}.}

\item{n_points}{number of equally spaced points
in the \code{x_range} if \code{x_seq} is unspecified}

\item{transformations}{named list of transformations to be applied
to specific parameters}

\item{transform_orthonormal}{whether factors with orthonormal prior
distributions should be transformed to differences from the grand
mean}

\item{short_name}{whether prior distribution names should be
shorted}

\item{parameter_names}{whether parameter names should be
printed}

\item{formula_prefix}{whether the parameter prefix from formula should
be printed. Defaults to \code{TRUE}.}

\item{...}{additional arguments}
}
\value{
\code{diagnostics} returns either \code{NULL} if \code{plot_type = "base"}
or an object/list of objects (depending on the number of parameters to be plotted)
of class 'ggplot2' if \code{plot_type = "ggplot2"}.
}
\description{
Creates density plots, trace plots, and autocorrelation plots
for a given parameter of a JAGS model.
}
\seealso{
\code{\link[=JAGS_fit]{JAGS_fit()}} \code{\link[=JAGS_check_convergence]{JAGS_check_convergence()}}
}
