/*
 * Decompiled with CFR 0.152.
 */
package org.trie4j.louds.bvtree;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.trie4j.bv.BytesSuccinctBitVector;
import org.trie4j.bv.SuccinctBitVector;
import org.trie4j.louds.bvtree.BvTree;
import org.trie4j.util.Range;

public class LOUDSBvTree
implements Externalizable,
BvTree {
    private SuccinctBitVector sbv;

    public LOUDSBvTree() {
        this(0);
    }

    public LOUDSBvTree(int initialNodeCapacity) {
        this.sbv = new BytesSuccinctBitVector(initialNodeCapacity * 2);
    }

    public LOUDSBvTree(SuccinctBitVector sbv) {
        this.sbv = sbv;
    }

    public SuccinctBitVector getSbv() {
        return this.sbv;
    }

    public String toString() {
        String bvs = this.sbv.toString();
        return "bitvec: " + (bvs.length() > 100 ? bvs.substring(0, 100) : bvs);
    }

    @Override
    public void appendChild() {
        this.sbv.append1();
    }

    @Override
    public void appendSelf() {
        this.sbv.append0();
    }

    @Override
    public void getChildNodeIds(int selfNodeId, Range range) {
        int s = this.sbv.select0(selfNodeId) + 1;
        int e = this.sbv.next0(s);
        int startNodeId = this.sbv.rank1(s);
        range.set(startNodeId, startNodeId + e - s);
    }

    @Override
    public void trimToSize() {
        this.sbv.trimToSize();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sbv = (SuccinctBitVector)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.sbv);
    }
}

