/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.xml.bind.annotation.XmlAttribute;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;

public final class StatProjectProperties {
    @JsonProperty(value="name")
    private final String projectName;
    @JsonProperty(value="root")
    private final String projectRoot;
    @JsonProperty(value="source-langauge")
    private final String sourceLanguage;
    @JsonProperty(value="target-language")
    private final String targetLanguage;
    @JsonIgnore
    private final String sourceRoot;

    public StatProjectProperties() {
        ProjectProperties props = Core.getProject().getProjectProperties();
        this.projectName = props.getProjectName();
        this.projectRoot = props.getProjectRoot();
        this.sourceLanguage = props.getSourceLanguage().getLanguage();
        this.targetLanguage = props.getTargetLanguage().getLanguage();
        this.sourceRoot = props.getSourceRoot();
    }

    @XmlAttribute(name="name")
    public String getProjectName() {
        return this.projectName;
    }

    @XmlAttribute(name="root")
    public String getProjectRoot() {
        return this.projectRoot;
    }

    @XmlAttribute(name="source-language")
    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    @XmlAttribute(name="target-language")
    public String getTargetLanguage() {
        return this.targetLanguage;
    }

    public String getSourceRoot() {
        return this.sourceRoot;
    }
}

