/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.omegat.util.FileUtil;

public class DirectoryMonitor
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(DirectoryMonitor.class.getName());
    private boolean stopped = false;
    protected final File dir;
    protected final Callback callback;
    protected final DirectoryCallback directoryCallback;
    private final Map<String, FileInfo> existFiles = new TreeMap<String, FileInfo>();
    protected static final long LOOKUP_PERIOD = 1000L;

    public DirectoryMonitor(File dir, Callback callback) {
        if (dir == null) {
            throw new IllegalArgumentException("Dir cannot be null.");
        }
        this.dir = dir;
        this.callback = callback;
        this.directoryCallback = null;
    }

    public DirectoryMonitor(File dir, Callback callback, DirectoryCallback directoryCallback) {
        if (dir == null) {
            throw new IllegalArgumentException("Dir cannot be null.");
        }
        this.dir = dir;
        this.callback = callback;
        this.directoryCallback = directoryCallback;
    }

    public File getDir() {
        return this.dir;
    }

    public void fin() {
        this.stopped = true;
    }

    @Override
    public void run() {
        this.setName(this.getClass().getSimpleName());
        this.setPriority(1);
        while (!this.stopped) {
            this.checkChanges();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                this.stopped = true;
            }
        }
    }

    public synchronized Set<File> getExistFiles() {
        TreeSet<File> result = new TreeSet<File>();
        for (String fn : this.existFiles.keySet()) {
            result.add(new File(fn));
        }
        return result;
    }

    public synchronized void checkChanges() {
        boolean directoryChanged = false;
        for (String fn : new ArrayList<String>(this.existFiles.keySet())) {
            if (this.stopped) {
                return;
            }
            File f = new File(fn);
            if (!f.exists()) {
                LOGGER.finer("File '" + f + "' removed");
                this.existFiles.remove(fn);
                this.callback.fileChanged(f);
                directoryChanged = true;
                continue;
            }
            FileInfo fi = new FileInfo(f);
            if (fi.equals(this.existFiles.get(fn))) continue;
            LOGGER.finer("File '" + f + "' changed");
            this.existFiles.put(fn, fi);
            this.callback.fileChanged(f);
            directoryChanged = true;
        }
        List<File> foundFiles = FileUtil.findFiles(this.dir, pathname -> true);
        for (File f : foundFiles) {
            if (this.stopped) {
                return;
            }
            String fn = f.getPath();
            if (this.existFiles.keySet().contains(fn)) continue;
            LOGGER.finer("File '" + f + "' added");
            this.existFiles.put(fn, new FileInfo(f));
            this.callback.fileChanged(f);
            directoryChanged = true;
        }
        if (this.directoryCallback != null && directoryChanged) {
            this.directoryCallback.directoryChanged(this.dir);
        }
    }

    public static interface DirectoryCallback {
        public void directoryChanged(File var1);
    }

    public static interface Callback {
        public void fileChanged(File var1);
    }

    protected static class FileInfo {
        public long lastModified;
        public long length;

        public FileInfo(File file) {
            this.lastModified = file.lastModified();
            this.length = file.length();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof FileInfo)) {
                return false;
            }
            FileInfo o = (FileInfo)obj;
            return this.lastModified == o.lastModified && this.length == o.length;
        }

        public int hashCode() {
            return Objects.hash(this.lastModified, this.length);
        }
    }
}

