/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm;

import edu.berkeley.nlp.lm.NgramLanguageModel;
import edu.berkeley.nlp.lm.collections.BoundedList;
import java.util.List;

public interface ArrayEncodedNgramLanguageModel<W>
extends NgramLanguageModel<W> {
    public float getLogProb(int[] var1, int var2, int var3);

    public float getLogProb(int[] var1);

    public static class DefaultImplementations {
        public static <T> float scoreSentence(List<T> sentence, ArrayEncodedNgramLanguageModel<T> lm) {
            float scoreNgram;
            List ngram;
            int i;
            BoundedList<T> sentenceWithBounds = new BoundedList<T>(sentence, lm.getWordIndexer().getStartSymbol(), lm.getWordIndexer().getEndSymbol());
            int lmOrder = lm.getLmOrder();
            float sentenceScore = 0.0f;
            for (i = 1; i < lmOrder - 1 && i <= sentenceWithBounds.size() + 1; ++i) {
                ngram = sentenceWithBounds.subList(-1, i);
                scoreNgram = lm.getLogProb(ngram);
                sentenceScore += scoreNgram;
            }
            for (i = lmOrder - 1; i < sentenceWithBounds.size() + 2; ++i) {
                ngram = sentenceWithBounds.subList(i - lmOrder, i);
                scoreNgram = lm.getLogProb(ngram);
                sentenceScore += scoreNgram;
            }
            return sentenceScore;
        }

        public static <T> float getLogProb(int[] ngram, ArrayEncodedNgramLanguageModel<T> lm) {
            return lm.getLogProb(ngram, 0, ngram.length);
        }

        public static <T> float getLogProb(List<T> ngram, ArrayEncodedNgramLanguageModel<T> lm) {
            int[] ints = NgramLanguageModel.StaticMethods.toIntArray(ngram, lm);
            return lm.getLogProb(ints, 0, ints.length);
        }
    }
}

