/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.io;

import edu.berkeley.nlp.lm.ConfigOptions;
import edu.berkeley.nlp.lm.StringWordIndexer;
import edu.berkeley.nlp.lm.io.LmReaders;
import edu.berkeley.nlp.lm.util.Logger;
import java.io.File;
import java.util.ArrayList;

public class MakeKneserNeyArpaFromText {
    private static void usage() {
        System.err.println("Usage: <lmOrder> <ARPA lm output file> <textfiles>*");
        System.exit(1);
    }

    public static void main(String[] argv) {
        if (argv.length < 2) {
            MakeKneserNeyArpaFromText.usage();
        }
        int lmOrder = Integer.parseInt(argv[0]);
        String outputFile = argv[1];
        ArrayList<String> inputFiles = new ArrayList<String>();
        for (int i = 2; i < argv.length; ++i) {
            inputFiles.add(argv[i]);
        }
        if (inputFiles.isEmpty()) {
            inputFiles.add("-");
        }
        Logger.setGlobalLogger(new Logger.SystemLogger(System.out, System.err));
        Logger.startTrack("Reading text files " + inputFiles + " and writing to file " + outputFile, new Object[0]);
        StringWordIndexer wordIndexer = new StringWordIndexer();
        wordIndexer.setStartSymbol("<s>");
        wordIndexer.setEndSymbol("</s>");
        wordIndexer.setUnkSymbol("<unk>");
        LmReaders.createKneserNeyLmFromTextFiles(inputFiles, wordIndexer, lmOrder, new File(outputFile), new ConfigOptions());
        Logger.endTrack();
    }
}

