/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.team2;

import java.io.File;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.omegat.core.team2.RemoteRepositoryProvider;
import org.omegat.util.Log;

public final class RebaseAndCommit {
    private static final Logger LOGGER = Logger.getLogger(RebaseAndCommit.class.getName());
    public static final String VERSION_PREFIX = "version-based-on.";

    private RebaseAndCommit() {
    }

    public static Prepared prepare(RemoteRepositoryProvider provider, File projectDir, String path) throws Exception {
        String headVersion;
        if (!provider.isUnderMapping(path)) {
            throw new RuntimeException("Path is not under mapping: " + path);
        }
        String savedVersion = provider.getTeamSettings().get(VERSION_PREFIX + path);
        if (savedVersion == null) {
            return null;
        }
        Prepared r = new Prepared();
        r.path = path;
        String currentBaseVersion = savedVersion;
        Log.logDebug(LOGGER, "Retrieve BASE(" + currentBaseVersion + ") version of '" + path + "'", new Object[0]);
        File baseFile = provider.switchToVersionAndPropagateDeletes(path, currentBaseVersion);
        r.versionBase = currentBaseVersion;
        r.fileBase = provider.toPrepared(baseFile);
        Log.logDebug(LOGGER, "Retrieve HEAD version of '" + path + "'", new Object[0]);
        File headFile = provider.switchToVersionAndPropagateDeletes(path, null);
        r.versionHead = headVersion = provider.getVersion(path);
        r.fileHead = provider.toPrepared(headFile);
        return r;
    }

    public static void rebaseAndCommit(Prepared prep, RemoteRepositoryProvider provider, File projectDir, String path, IRebase rebaser) throws Exception {
        boolean fileChangedRemotely;
        boolean fileChangedLocally;
        String currentBaseVersion;
        if (!provider.isUnderMapping(path)) {
            throw new RuntimeException("Path is not under mapping: " + path);
        }
        Log.logDebug(LOGGER, "Rebase and commit '" + path + "'", new Object[0]);
        String savedVersion = provider.getTeamSettings().get(VERSION_PREFIX + path);
        if (savedVersion != null) {
            currentBaseVersion = savedVersion;
        } else {
            provider.switchToVersionAndPropagateDeletes(path, null);
            currentBaseVersion = provider.getVersion(path);
        }
        File localFile = new File(projectDir, path);
        File baseRepoFile = null;
        if (prep != null && prep.versionBase.equals(currentBaseVersion)) {
            baseRepoFile = prep.fileBase;
        }
        if (baseRepoFile == null) {
            baseRepoFile = provider.switchToVersionAndPropagateDeletes(path, currentBaseVersion);
        }
        if (!localFile.exists()) {
            Log.logDebug(LOGGER, "local file '" + path + "' doesn't exist", new Object[0]);
            fileChangedLocally = false;
        } else if (FileUtils.contentEquals(baseRepoFile, localFile)) {
            Log.logDebug(LOGGER, "local file '" + path + "' wasn't changed", new Object[0]);
            fileChangedLocally = false;
        } else {
            Log.logDebug(LOGGER, "local file '" + path + "' was changed", new Object[0]);
            fileChangedLocally = true;
            rebaser.parseBaseFile(baseRepoFile);
        }
        File headRepoFile = null;
        String headVersion = null;
        if (prep != null) {
            headVersion = prep.versionHead;
            headRepoFile = prep.fileHead;
        }
        if (headVersion == null) {
            headRepoFile = provider.switchToVersionAndPropagateDeletes(path, null);
            headVersion = provider.getVersion(path);
        }
        if (!localFile.exists()) {
            if (headRepoFile.exists()) {
                fileChangedRemotely = true;
                rebaser.parseHeadFile(headRepoFile);
            } else {
                fileChangedRemotely = false;
            }
        } else if (StringUtils.equals((String)currentBaseVersion, (String)headVersion)) {
            Log.logDebug(LOGGER, "remote file '" + path + "' wasn't changed", new Object[0]);
            fileChangedRemotely = false;
        } else {
            Log.logDebug(LOGGER, "remote file '" + path + "' was changed", new Object[0]);
            fileChangedRemotely = true;
            rebaser.parseHeadFile(headRepoFile);
        }
        File tempOut = new File(projectDir, path + "#based_on_" + headVersion);
        if (tempOut.exists() && !tempOut.delete()) {
            throw new Exception("Unable to delete previous temp file");
        }
        boolean needBackup = false;
        if (fileChangedLocally && fileChangedRemotely) {
            Log.logDebug(LOGGER, "rebase and save '" + path + "'", new Object[0]);
            needBackup = true;
            rebaser.rebaseAndSave(tempOut);
        } else if (fileChangedLocally && !fileChangedRemotely) {
            Log.logDebug(LOGGER, "only local changes - just use local file '" + path + "'", new Object[0]);
        } else if (!fileChangedLocally && fileChangedRemotely) {
            Log.logDebug(LOGGER, "only remote changes - get remote '" + path + "'", new Object[0]);
            needBackup = true;
            if (headRepoFile.exists()) {
                FileUtils.copyFile(headRepoFile, tempOut);
            }
        } else {
            Log.logDebug(LOGGER, "there are no changes '" + path + "'", new Object[0]);
        }
        if (needBackup) {
            if (localFile.exists()) {
                File bakTemp = new File(projectDir, path + "#oldbased_on_" + currentBaseVersion);
                bakTemp.delete();
                FileUtils.moveFile(localFile, bakTemp);
            }
            provider.getTeamSettings().set(VERSION_PREFIX + path, headVersion);
            if (tempOut.exists()) {
                localFile.delete();
                FileUtils.moveFile(tempOut, localFile);
            }
        }
        if (prep != null) {
            prep.needToCommit = fileChangedLocally;
            prep.commitComment = rebaser.getCommentForCommit();
            if (fileChangedLocally) {
                prep.charset = rebaser.getFileCharset(localFile);
            }
            return;
        }
        if (fileChangedLocally) {
            String comment = rebaser.getCommentForCommit();
            provider.copyFilesFromProjectToRepos(path, rebaser.getFileCharset(localFile));
            String newVersion = provider.commitFileAfterVersion(path, comment, headVersion, null);
            if (newVersion != null) {
                provider.getTeamSettings().set(VERSION_PREFIX + path, newVersion);
            }
        }
    }

    public static String commitPrepared(Prepared prep, RemoteRepositoryProvider provider, String possibleHeadVersion) throws Exception {
        if (!prep.needToCommit) {
            return null;
        }
        provider.copyFilesFromProjectToRepos(prep.path, prep.charset);
        String newVersion = provider.commitFileAfterVersion(prep.path, prep.commitComment, prep.versionHead, possibleHeadVersion);
        if (newVersion != null) {
            provider.getTeamSettings().set(VERSION_PREFIX + prep.path, newVersion);
        }
        return newVersion;
    }

    public static class Prepared {
        public String path;
        public File fileBase;
        public File fileHead;
        public String versionBase;
        public String versionHead;
        public boolean needToCommit;
        public String commitComment;
        public String charset;
    }

    public static interface IRebase {
        public void parseBaseFile(File var1) throws Exception;

        public void parseHeadFile(File var1) throws Exception;

        public void rebaseAndSave(File var1) throws Exception;

        public String getCommentForCommit();

        public String getFileCharset(File var1) throws Exception;
    }
}

