/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

public final class Platform {
    private static OsType osType = OsType.OTHER;

    private Platform() {
    }

    public static OsType getOsType() {
        return osType;
    }

    public static boolean isWebStart() {
        return System.getProperty("javawebstart.version") != null;
    }

    public static boolean isMacOSX() {
        OsType os = Platform.getOsType();
        return os == OsType.MAC32 || os == OsType.MAC64;
    }

    public static boolean is64Bit() {
        String osArch = System.getProperty("os.arch");
        if (osArch != null) {
            return osArch.contains("64");
        }
        return false;
    }

    static {
        String osName = System.getProperty("os.name");
        if (osName != null && System.getProperty("os.arch") != null) {
            boolean is64 = Platform.is64Bit();
            if (osName.startsWith("Linux")) {
                osType = is64 ? OsType.LINUX64 : OsType.LINUX32;
            } else if (osName.contains("OS X")) {
                osType = is64 ? OsType.MAC64 : OsType.MAC32;
            } else if (osName.startsWith("Windows")) {
                osType = is64 ? OsType.WIN64 : OsType.WIN32;
            }
        }
    }

    public static enum OsType {
        LINUX64,
        LINUX32,
        MAC64,
        MAC32,
        WIN64,
        WIN32,
        OTHER;

    }
}

