/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.apache.commons.io.IOUtils;
import org.omegat.help.Help;
import org.omegat.util.OStrings;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class LicenseDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JPanel buttonPanel;
    private JScrollPane scroll;
    private JTextPane licenseTextPane;
    private JButton okButton;
    private int returnStatus = 0;

    public LicenseDialog(Dialog parent) {
        super(parent, true);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.licenseTextPane.setCaretPosition(0);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.scroll = new JScrollPane();
        this.licenseTextPane = new JTextPane();
        this.setTitle(OStrings.getString("LICENSEDIALOG_TITLE"));
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LicenseDialog.this.closeDialog(evt);
            }
        });
        StaticUIUtils.setEscapeClosable(this);
        this.buttonPanel.setLayout(new FlowLayout(2));
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.licenseTextPane.setEditable(false);
        StringBuilder sb = new StringBuilder("===================================================\n\n");
        sb.append(OStrings.getString("LICENSEDIALOG_PREFACE"));
        sb.append("\n\n===================================================\n\n");
        try {
            String text = IOUtils.toString(Help.getHelpFileURI("OmegaT-license.txt"), StandardCharsets.UTF_8);
            sb.append(text);
        }
        catch (IOException | NullPointerException ex) {
            sb.append(Help.errorHaiku());
        }
        this.licenseTextPane.setText(sb.toString());
        this.scroll.setViewportView(this.licenseTextPane);
        this.getContentPane().add((Component)this.scroll, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 600) / 2, (screenSize.height - 400) / 2, 600, 400);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

