/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.nbjshell;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.jshell.execution.JdiExecutionControl;
import jdk.jshell.execution.JdiInitiator;
import jdk.jshell.execution.Util;
import jdk.jshell.spi.ExecutionControl;
import jdk.jshell.spi.ExecutionControlProvider;
import jdk.jshell.spi.ExecutionEnv;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.lib.nbjshell.NbExecutionControl;
import org.netbeans.lib.nbjshell.RemoteJShellService;

public class LaunchJDIAgent
extends JdiExecutionControl
implements ExecutionControl,
RemoteJShellService,
NbExecutionControl {
    private static final Logger LOG = Logger.getLogger(LaunchJDIAgent.class.getName());
    private static final String REMOTE_AGENT = "org.netbeans.lib.jshell.agent.AgentWorker";
    protected final ObjectInput in;
    protected final ObjectOutput out;
    protected VirtualMachine vm;
    private Process process;
    private final Object STOP_LOCK = new Object();
    private boolean userCodeRunning = false;
    private boolean closed = false;
    private boolean suppressClasspath;

    public LaunchJDIAgent(ObjectOutput out, ObjectInput in, VirtualMachine vm) {
        super(out, in);
        this.in = in;
        this.out = out;
        this.vm = vm;
    }

    private LaunchJDIAgent(ObjectOutput cmdout, ObjectInput cmdin, VirtualMachine vm, Process process, List<Consumer<String>> deathListeners) {
        this(cmdout, cmdin, vm);
        this.process = process;
        deathListeners.add(s -> this.disposeVM());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeStreams() {
        LaunchJDIAgent launchJDIAgent = this;
        synchronized (launchJDIAgent) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void notifyClosed() {
        this.closeStreams();
    }

    @Override
    public Map<String, String> commandVersionInfo() {
        Map<String, String> result = new HashMap<String, String>();
        try {
            Object o = this.extensionCommand("nb_vmInfo", null);
            if (!(o instanceof Map)) {
                return Collections.emptyMap();
            }
            result = (Map)o;
        }
        catch (ExecutionControl.InternalException | ExecutionControl.RunException ex) {
            LOG.log(Level.INFO, "Error invoking JShell agent", ex.toString());
        }
        catch (ExecutionControl.EngineTerminationException ex) {
            this.notifyClosed();
        }
        return result;
    }

    protected ObjectReference getAgentObjectReference() {
        return null;
    }

    @Override
    public boolean requestShutdown() {
        this.disposeVM();
        return true;
    }

    public boolean isClosed() {
        return this.vm == null;
    }

    @Override
    public String getTargetSpec() {
        return null;
    }

    public static ExecutionControlProvider launch(final JavaPlatform platform) {
        return new ExecutionControlProvider(){

            @Override
            public String name() {
                return this.getClass().getName();
            }

            @Override
            public ExecutionControl generate(ExecutionEnv ee, Map<String, String> map) throws Throwable {
                return LaunchJDIAgent.create(platform, ee, true, map);
            }
        };
    }

    private static JdiExecutionControl create(JavaPlatform platform, ExecutionEnv env, boolean isLaunch, Map<String, String> customArgs) throws IOException {
        try (ServerSocket listener = new ServerSocket(0);){
            listener.setSoTimeout(60000);
            int port = listener.getLocalPort();
            HashMap<String, String> customArguments = new HashMap<String, String>();
            if (customArgs != null) {
                customArguments.putAll(customArgs);
            }
            if (platform != null) {
                String jHome = (String)platform.getSystemProperties().get("java.home");
                customArguments.put("home", jHome);
            }
            String loopback = InetAddress.getLoopbackAddress().getHostAddress();
            JdiInitiator jdii = new JdiInitiator(port, env.extraRemoteVMOptions(), REMOTE_AGENT, isLaunch, loopback, 5000, customArguments);
            VirtualMachine vm = jdii.vm();
            Process process = jdii.process();
            ArrayList<Consumer<String>> deathListeners = new ArrayList<Consumer<String>>();
            deathListeners.add(s -> env.closeDown());
            vm.resume();
            Socket socket = listener.accept();
            HashMap<String, OutputStream> io = new HashMap<String, OutputStream>();
            CloseFilter outFilter = new CloseFilter(env.userOut());
            io.put("out", outFilter);
            io.put("err", env.userErr());
            LaunchJDIAgent agent = (LaunchJDIAgent)Util.remoteInputOutput(socket.getInputStream(), socket.getOutputStream(), io, Collections.emptyMap(), (cmdIn, cmdOut) -> new LaunchJDIAgent((ObjectOutput)cmdOut, (ObjectInput)cmdIn, vm, process, (List<Consumer<String>>)deathListeners));
            Util.detectJdiExitEvent(vm, s -> {
                for (Consumer h : deathListeners) {
                    h.accept(s);
                }
                agent.disposeVM();
            });
            outFilter.agent = agent;
            LaunchJDIAgent launchJDIAgent = agent;
            return launchJDIAgent;
        }
    }

    @Override
    public void addToClasspath(String path) throws ExecutionControl.EngineTerminationException, ExecutionControl.InternalException {
        if (!this.suppressClasspath) {
            super.addToClasspath(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String invoke(String classname, String methodname) throws ExecutionControl.RunException, ExecutionControl.EngineTerminationException, ExecutionControl.InternalException {
        String res;
        Object object = this.STOP_LOCK;
        synchronized (object) {
            this.userCodeRunning = true;
        }
        try {
            res = super.invoke(classname, methodname);
        }
        finally {
            object = this.STOP_LOCK;
            synchronized (object) {
                this.userCodeRunning = false;
            }
        }
        return res;
    }

    protected boolean isUserCodeRunning() {
        return this.userCodeRunning;
    }

    protected Object getLock() {
        return this.STOP_LOCK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws ExecutionControl.EngineTerminationException, ExecutionControl.InternalException {
        Object object = this.STOP_LOCK;
        synchronized (object) {
            block12: {
                if (!this.userCodeRunning) {
                    return;
                }
                this.vm().suspend();
                try {
                    for (ThreadReference thread : this.vm().allThreads()) {
                        for (StackFrame frame : thread.frames()) {
                            if (!REMOTE_AGENT.equals(frame.location().declaringType().name()) || !"invoke".equals(frame.location().method().name()) && !"varValue".equals(frame.location().method().name())) continue;
                            ObjectReference thiz = frame.thisObject();
                            Field inClientCode = thiz.referenceType().fieldByName("inClientCode");
                            Field expectingStop = thiz.referenceType().fieldByName("expectingStop");
                            Field stopException = thiz.referenceType().fieldByName("stopException");
                            if (((BooleanValue)thiz.getValue(inClientCode)).value()) {
                                thiz.setValue(expectingStop, this.vm().mirrorOf(true));
                                ObjectReference stopInstance = (ObjectReference)thiz.getValue(stopException);
                                this.vm().resume();
                                LaunchJDIAgent.debug("Attempting to stop the client code...\n", new Object[0]);
                                thread.stop(stopInstance);
                                thiz.setValue(expectingStop, this.vm().mirrorOf(false));
                            }
                            break block12;
                        }
                    }
                }
                catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException ex) {
                    throw new ExecutionControl.InternalException("Exception on remote stop: " + ex);
                }
                finally {
                    this.vm().resume();
                }
            }
        }
    }

    @Override
    public void close() {
        super.close();
        this.disposeVM();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void disposeVM() {
        if (this.process != null) {
            try {
                if (this.vm == null) return;
                this.vm.dispose();
                this.vm = null;
                return;
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                return;
            }
            catch (Throwable ex) {
                LaunchJDIAgent.debug(ex, "disposeVM");
                return;
            }
            finally {
                if (this.process != null) {
                    this.process.destroy();
                    this.process = null;
                }
            }
        } else {
            this.vm = null;
        }
    }

    @Override
    protected synchronized VirtualMachine vm() throws ExecutionControl.EngineTerminationException {
        if (this.vm == null) {
            throw new ExecutionControl.EngineTerminationException("VM closed");
        }
        return this.vm;
    }

    private static void debug(String format, Object ... args) {
    }

    private static void debug(Throwable ex, String where) {
    }

    @Override
    public void suppressClasspathChanges(boolean b) {
        this.suppressClasspath = b;
    }

    @Override
    public ExecutionControl.ExecutionControlException getBrokenException() {
        return null;
    }

    static class CloseFilter
    extends FilterOutputStream {
        volatile LaunchJDIAgent agent;

        public CloseFilter(OutputStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.agent != null) {
                this.agent.notifyClosed();
            }
        }
    }
}

