/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.utilities.NeverValidAssumption;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.util.DebugCounter;

public final class JSSharedData {
    private final JSContext context;
    private final JSDynamicObject proto;
    private Assumption prototypeAssumption;
    private static final DebugCounter prototypeAssumptionsCreated = DebugCounter.create("Prototype assumptions created");
    private static final DebugCounter prototypeAssumptionsRemoved = DebugCounter.create("Prototype assumptions removed");

    public JSSharedData(JSContext context, JSDynamicObject prototype) {
        this.context = context;
        this.proto = prototype;
    }

    JSContext getContext() {
        return this.context;
    }

    public JSDynamicObject getPrototype() {
        return this.proto;
    }

    synchronized Assumption getPrototypeAssumption() {
        Assumption assumption = this.prototypeAssumption;
        if (assumption == null) {
            this.prototypeAssumption = assumption = Truffle.getRuntime().createAssumption("stable prototype");
            prototypeAssumptionsCreated.inc();
        }
        return assumption;
    }

    synchronized void invalidatePrototypeAssumption() {
        Assumption assumption = this.prototypeAssumption;
        if (assumption != null) {
            assumption.invalidate();
            this.prototypeAssumption = NeverValidAssumption.INSTANCE;
            prototypeAssumptionsRemoved.inc();
        }
    }
}

