/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.maven;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectActionContext;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.micronaut.AbstractMicronautArtifacts;
import org.netbeans.modules.project.dependency.ArtifactSpec;
import org.netbeans.modules.project.dependency.ProjectArtifactsQuery;
import org.netbeans.modules.project.dependency.spi.ProjectArtifactsImplementation;
import org.netbeans.spi.project.LookupProvider;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class MicronautPackagingArtifactsImpl
implements ProjectArtifactsImplementation<R> {
    private static final Logger LOG = Logger.getLogger(MicronautPackagingArtifactsImpl.class.getName());
    public static final String PLUGIN_PARAM_SHAREDLIBRARY = "sharedLibrary";
    private static final Set<String> SUPPORTED_ARTIFACT_TYPES = new HashSet<String>(Arrays.asList("dynlib", "exe"));
    public static final String PLUGIN_PARAM_IMAGENAME = "imageName";
    private final Project project;
    private final NbMavenProject mavenProject;

    public MicronautPackagingArtifactsImpl(Project project) {
        this.project = project;
        this.mavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        LOG.log(Level.FINE, "Created for project {0}", project.getProjectDirectory());
    }

    public R evaluate(ProjectArtifactsQuery.Filter query) {
        return new R(this.project, this.mavenProject, query);
    }

    public Project findProject(R r) {
        return r.getProject();
    }

    public List<ArtifactSpec> findArtifacts(R r) {
        return r.getArtifacts();
    }

    public Collection<ArtifactSpec> findExcludedArtifacts(R r) {
        return r.getExcludedArtifacts();
    }

    public void handleChangeListener(R r, ChangeListener l, boolean add) {
        if (add) {
            r.addChangeListener(l);
        } else {
            r.removeChangeListener(l);
        }
    }

    public boolean computeSupportsChanges(R r) {
        return true;
    }

    public static LookupProvider projectLookup(Map<Object, Object> attrs) {
        return new LookupProvider(){

            public Lookup createAdditionalLookup(Lookup baseContext) {
                Project p = (Project)baseContext.lookup(Project.class);
                if (p == null) {
                    return Lookup.EMPTY;
                }
                return Lookups.fixed((Object[])new Object[]{new MicronautPackagingArtifactsImpl(p)});
            }
        };
    }

    static class R
    extends AbstractMicronautArtifacts {
        private final NbMavenProject mavenProject;

        public R(Project project, NbMavenProject mavenProject, ProjectArtifactsQuery.Filter query) {
            super(project, query);
            this.mavenProject = mavenProject;
        }

        @Override
        protected void attach(PropertyChangeListener l) {
            this.mavenProject.addPropertyChangeListener(l);
        }

        @Override
        protected void detach(PropertyChangeListener l) {
        }

        @Override
        protected boolean accept(PropertyChangeEvent e) {
            return "MavenProject".equals(e.getPropertyName());
        }

        @Override
        protected List<ArtifactSpec> compute() {
            ProjectActionContext buildCtx = this.query.getBuildContext() != null ? (this.query.getBuildContext().getProjectAction() == null ? this.query.getBuildContext().newDerivedBuilder().forProjectAction("build").context() : this.query.getBuildContext()) : ProjectActionContext.newBuilder((Project)this.getProject()).forProjectAction("build").context();
            if (this.query.getArtifactType() != null && !SUPPORTED_ARTIFACT_TYPES.contains(this.query.getArtifactType()) && !"<all>".equals(this.query.getArtifactType())) {
                LOG.log(Level.FINE, "Unsupported type: {0}", this.query.getArtifactType());
                return Collections.emptyList();
            }
            if (this.query.getClassifier() != null && !"<any>".equals(this.query.getClassifier())) {
                LOG.log(Level.FINE, "Unsupported classifier: {0}", this.query.getClassifier());
                return Collections.emptyList();
            }
            MavenProject model = this.mavenProject.getEvaluatedProject(buildCtx);
            if (!"native-image".equals(model.getPackaging())) {
                LOG.log(Level.FINE, "Unsupported packaging: {0}", model.getPackaging());
                return Collections.emptyList();
            }
            ArrayList<ArtifactSpec> nativeStuff = new ArrayList<ArtifactSpec>();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Configured build plugins: {0}", model.getBuild().getPlugins());
            }
            for (Plugin p : model.getBuild().getPlugins()) {
                if (!"org.graalvm.buildtools".equals(p.getGroupId()) || !"native-maven-plugin".equals(p.getArtifactId())) continue;
                LOG.log(Level.FINE, "Configured executions: {0}", p.getExecutions());
                for (PluginExecution pe : p.getExecutions()) {
                    Xpp3Dom dom;
                    if (!pe.getGoals().contains("build") || (dom = model.getGoalConfiguration("org.graalvm.buildtools", "native-maven-plugin", pe.getId(), "build")) == null) continue;
                    Xpp3Dom imageName = dom.getChild(MicronautPackagingArtifactsImpl.PLUGIN_PARAM_IMAGENAME);
                    Xpp3Dom sharedLib = dom.getChild(MicronautPackagingArtifactsImpl.PLUGIN_PARAM_SHAREDLIBRARY);
                    String name = imageName == null ? model.getArtifactId() : imageName.getValue();
                    Path full = Paths.get(model.getBuild().getDirectory(), new String[0]).resolve(name);
                    nativeStuff.add(ArtifactSpec.builder((String)model.getGroupId(), (String)model.getArtifactId(), (String)model.getVersion(), (Object)pe).type(sharedLib != null && Boolean.parseBoolean(sharedLib.getValue()) ? "dynlib" : "exe").location(full.toUri()).forceLocalFile(FileUtil.toFileObject((File)full.toFile())).build());
                }
            }
            return nativeStuff;
        }
    }
}

