/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.devops.model.BuildPipeline;
import com.oracle.bmc.devops.requests.CreateBuildPipelineRequest;
import com.oracle.bmc.devops.responses.CreateBuildPipelineResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateBuildPipelineConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateBuildPipelineConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateBuildPipelineRequest interceptRequest(CreateBuildPipelineRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateBuildPipelineRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateBuildPipelineDetails(), (String)"createBuildPipelineDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20210630").path("buildPipelines");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, CreateBuildPipelineResponse> fromResponse() {
        Function<Response, CreateBuildPipelineResponse> transformer = new Function<Response, CreateBuildPipelineResponse>(){

            public CreateBuildPipelineResponse apply(Response rawResponse) {
                Optional locationHeader;
                Optional opcRequestIdHeader;
                Optional opcWorkRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.devops.responses.CreateBuildPipelineResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(BuildPipeline.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                CreateBuildPipelineResponse.Builder builder = CreateBuildPipelineResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.buildPipeline((BuildPipeline)response.getItem());
                Optional etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag");
                if (etagHeader.isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((opcWorkRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-work-request-id")).isPresent()) {
                    builder.opcWorkRequestId((String)HeaderUtils.toValue((String)"opc-work-request-id", (String)((String)((List)opcWorkRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((locationHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"location")).isPresent()) {
                    builder.location((String)HeaderUtils.toValue((String)"location", (String)((String)((List)locationHeader.get()).get(0)), String.class));
                }
                CreateBuildPipelineResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

