/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletPreferences;
import javax.portlet.PreferencesValidator;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import org.springframework.util.Assert;

public class MockPortletPreferences
implements PortletPreferences {
    private PreferencesValidator preferencesValidator;
    private final Map<String, String[]> preferences = new LinkedHashMap<String, String[]>();
    private final Set<String> readOnly = new HashSet<String>();

    public void setReadOnly(String key, boolean readOnly) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        if (readOnly) {
            this.readOnly.add(key);
        } else {
            this.readOnly.remove(key);
        }
    }

    public boolean isReadOnly(String key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        return this.readOnly.contains(key);
    }

    public String getValue(String key, String def) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        String[] values = this.preferences.get(key);
        return values != null && values.length > 0 ? values[0] : def;
    }

    public String[] getValues(String key, String[] def) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        String[] values = this.preferences.get(key);
        return values != null && values.length > 0 ? values : def;
    }

    public void setValue(String key, String value) throws ReadOnlyException {
        this.setValues(key, new String[]{value});
    }

    public void setValues(String key, String[] values) throws ReadOnlyException {
        Assert.notNull((Object)key, (String)"Key must not be null");
        if (this.isReadOnly(key)) {
            throw new ReadOnlyException("Preference '" + key + "' is read-only");
        }
        this.preferences.put(key, values);
    }

    public Enumeration<String> getNames() {
        return Collections.enumeration(this.preferences.keySet());
    }

    public Map<String, String[]> getMap() {
        return Collections.unmodifiableMap(this.preferences);
    }

    public void reset(String key) throws ReadOnlyException {
        Assert.notNull((Object)key, (String)"Key must not be null");
        if (this.isReadOnly(key)) {
            throw new ReadOnlyException("Preference '" + key + "' is read-only");
        }
        this.preferences.remove(key);
    }

    public void setPreferencesValidator(PreferencesValidator preferencesValidator) {
        this.preferencesValidator = preferencesValidator;
    }

    public void store() throws IOException, ValidatorException {
        if (this.preferencesValidator != null) {
            this.preferencesValidator.validate((PortletPreferences)this);
        }
    }
}

