/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.KeyComparator;
import org.netbeans.modules.properties.KeyNode;
import org.netbeans.modules.properties.PresentableFileEntry;
import org.netbeans.modules.properties.PropertiesDataLoader;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesEditorSupport;
import org.netbeans.modules.properties.PropertiesLocaleNode;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.PropertyBundleEvent;
import org.netbeans.modules.properties.PropertyBundleListener;
import org.netbeans.modules.properties.StructHandler;
import org.netbeans.modules.properties.Util;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class PropertiesFileEntry
extends PresentableFileEntry
implements CookieSet.Factory {
    static final Logger LOG = Logger.getLogger(PropertiesFileEntry.class.getName());
    private String basicName;
    private transient StructHandler propStruct;
    private transient PropertiesEditorSupport editorSupport;
    transient Object atomicUndoRedoFlag;
    static final long serialVersionUID = -3882240297814143015L;
    private final FileChangeAdapter list;
    private FileChangeListener weakList;

    PropertiesFileEntry(MultiDataObject obj, FileObject file) {
        super(obj, file);
        FileObject fo;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("new PropertiesFileEntry(<MultiDataObject>, " + FileUtil.getFileDisplayName((FileObject)file) + ')');
            LOG.finer("  - new PresentableFileEntry(<MultiDataObject>, " + FileUtil.getFileDisplayName((FileObject)file) + ')');
        }
        this.basicName = (fo = this.getDataObject().getPrimaryFile()) == null ? this.getFile().getName() : fo.getName();
        this.list = new FileChangeAdapter(){

            public void fileChanged(FileEvent fe) {
                PropertiesFileEntry.this.getHandler().autoParse();
            }

            public void fileDeleted(FileEvent fe) {
                PropertiesFileEntry.this.detachListener();
            }
        };
        this.attachListener(file);
        this.getCookieSet().add(PropertiesEditorSupport.class, (CookieSet.Factory)this);
    }

    public FileObject copy(FileObject folder, String suffix) throws IOException {
        String pasteSuffix;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("copy(" + FileUtil.getFileDisplayName((FileObject)folder) + ", " + (suffix != null ? '\"' + suffix + '\"' : "<null>") + ')');
        }
        if ((pasteSuffix = ((PropertiesDataObject)this.getDataObject()).getPasteSuffix()) == null) {
            return super.copy(folder, suffix);
        }
        FileObject fileObject = this.getFile();
        String basicName = this.getDataObject().getPrimaryFile().getName();
        String newName = basicName + pasteSuffix + Util.getLocaleSuffix((MultiDataObject.Entry)this);
        return fileObject.copy(folder, newName, fileObject.getExt());
    }

    @Override
    public void delete() throws IOException {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("delete()");
        }
        this.getHandler().stopParsing();
        this.detachListener();
        try {
            super.delete();
        }
        finally {
            this.getHandler().allowParsing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject move(FileObject folder, String suffix) throws IOException {
        String pasteSuffix;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("move(" + FileUtil.getFileDisplayName((FileObject)folder) + ", " + (suffix != null ? '\"' + suffix + '\"' : "<null>") + ')');
        }
        if ((pasteSuffix = ((PropertiesDataObject)this.getDataObject()).getPasteSuffix()) == null) {
            return super.move(folder, suffix);
        }
        boolean wasLocked = this.isLocked();
        FileObject fileObject = this.getFile();
        FileLock lock = this.takeLock();
        try {
            String basicName = this.getDataObject().getPrimaryFile().getName();
            String newName = basicName + pasteSuffix + Util.getLocaleSuffix((MultiDataObject.Entry)this);
            this.detachListener();
            FileObject fo = fileObject.move(lock, folder, newName, fileObject.getExt());
            this.attachListener(fo);
            FileObject fileObject2 = fo;
            return fileObject2;
        }
        finally {
            if (!wasLocked) {
                lock.releaseLock();
            }
        }
    }

    public <T extends Node.Cookie> T createCookie(Class<T> clazz) {
        if (clazz.isAssignableFrom(PropertiesEditorSupport.class)) {
            return (T)this.getPropertiesEditor();
        }
        return null;
    }

    @Override
    protected Node createNodeDelegate() {
        return new PropertiesLocaleNode(this);
    }

    public Children getChildren() {
        return new PropKeysChildren();
    }

    public StructHandler getHandler() {
        if (this.propStruct == null) {
            this.propStruct = new StructHandler(this);
        }
        return this.propStruct;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertiesEditorSupport getPropertiesEditor() {
        PropertiesFileEntry propertiesFileEntry = this;
        synchronized (propertiesFileEntry) {
            if (this.editorSupport == null) {
                this.editorSupport = new PropertiesEditorSupport(this);
            }
        }
        return this.editorSupport;
    }

    @Override
    public FileObject rename(String name) throws IOException {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("rename(" + name + ')');
        }
        if (!this.getFile().getName().startsWith(this.basicName)) {
            throw new IllegalStateException("Resource Bundles: error in Properties loader/rename.");
        }
        this.detachListener();
        FileObject fo = super.rename(name + this.getFile().getName().substring(this.basicName.length()));
        this.attachListener(fo);
        this.basicName = name;
        return fo;
    }

    @Override
    public FileObject renameEntry(String name) throws IOException {
        if (!this.getFile().getName().startsWith(this.basicName)) {
            throw new IllegalStateException("Resource Bundles: error in Properties loader / rename");
        }
        if (this.basicName.equals(this.getFile().getName())) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getBundle(PropertiesDataLoader.class).getString("MSG_AttemptToRenamePrimaryFile"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            return this.getFile();
        }
        FileObject fo = super.rename(name);
        ((PropertiesDataObject)this.getDataObject()).getBundleStructure().notifyOneFileChanged(this.getHandler());
        return fo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject createFromTemplate(FileObject folder, String name) throws IOException {
        byte[] originalData;
        int count;
        String ext;
        if (!this.getFile().getName().startsWith(this.basicName)) {
            throw new IllegalStateException("Resource Bundles: error in Properties createFromTemplate");
        }
        String suffix = this.getFile().getName().substring(this.basicName.length());
        String nuename = name + suffix;
        FileObject existing = folder.getFileObject(nuename, ext = this.getFile().getExt());
        if (existing == null) {
            return super.createFromTemplate(folder, nuename);
        }
        byte[] buf = new byte[4096];
        FileLock lock = existing.lock();
        try {
            try (InputStream is = existing.getInputStream();){
                ByteArrayOutputStream baos = new ByteArrayOutputStream((int)existing.getSize());
                try {
                    while ((count = is.read(buf)) != -1) {
                        baos.write(buf, 0, count);
                    }
                }
                finally {
                    originalData = baos.toByteArray();
                    baos.close();
                }
            }
            existing.delete(lock);
        }
        finally {
            lock.releaseLock();
        }
        FileObject nue = folder.createData(nuename, ext);
        lock = nue.lock();
        try (OutputStream os = nue.getOutputStream(lock);){
            os.write(originalData);
            try (InputStream is = this.getFile().getInputStream();){
                while ((count = is.read(buf)) != -1) {
                    os.write(buf, 0, count);
                }
            }
        }
        finally {
            lock.releaseLock();
        }
        return nue;
    }

    @Override
    public boolean isDeleteAllowed() {
        return this.getFile().canWrite() && !this.basicName.equals(this.getFile().getName());
    }

    @Override
    public boolean isCopyAllowed() {
        return true;
    }

    @Override
    public boolean isMoveAllowed() {
        return this.getFile().canWrite() && this.getDataObject().getPrimaryEntry() != this;
    }

    @Override
    public boolean isRenameAllowed() {
        return this.getFile().canWrite();
    }

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx("propfiles.creating");
    }

    private void attachListener(FileObject fo) {
        this.weakList = (FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this.list, (Object)fo);
        fo.addFileChangeListener(this.weakList);
    }

    private void detachListener() {
        FileObject fo = this.getFile();
        fo.removeFileChangeListener(this.weakList);
        this.weakList = null;
    }

    private class PropKeysChildren
    extends Children.Keys<String> {
        private PropertyBundleListener bundleListener = null;

        PropKeysChildren() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void mySetKeys() {
            TreeSet<String> keys = new TreeSet<String>(new KeyComparator());
            PropertiesStructure propStructure = PropertiesFileEntry.this.getHandler().getStructure();
            if (propStructure != null) {
                BundleStructure bundleStructure = propStructure.getParentBundleStructure();
                synchronized (bundleStructure) {
                    StructHandler structHandler = propStructure.getParent();
                    synchronized (structHandler) {
                        Iterator<Element.ItemElem> iterator = propStructure.allItems();
                        while (iterator.hasNext()) {
                            Element.ItemElem item = iterator.next();
                            if (item == null || item.getKey() == null) continue;
                            keys.add(item.getKey());
                        }
                    }
                }
            }
            this.setKeys(keys);
        }

        protected void addNotify() {
            this.mySetKeys();
            this.bundleListener = new PropertyBundleListener(){

                @Override
                public void bundleChanged(PropertyBundleEvent evt) {
                    int changeType = evt.getChangeType();
                    if (changeType == 1 || changeType == 2) {
                        PropKeysChildren.this.mySetKeys();
                    } else if (changeType == 3 && evt.getEntryName().equals(PropertiesFileEntry.this.getFile().getName())) {
                        PropKeysChildren.this.mySetKeys();
                    }
                }
            };
            this.bundleStructure().addPropertyBundleListener(this.bundleListener);
        }

        protected void removeNotify() {
            this.bundleStructure().removePropertyBundleListener(this.bundleListener);
            this.setKeys(new ArrayList());
        }

        protected Node[] createNodes(String itemKey) {
            return new Node[]{new KeyNode(PropertiesFileEntry.this.getHandler().getStructure(), itemKey)};
        }

        private BundleStructure bundleStructure() {
            return ((PropertiesDataObject)PropertiesFileEntry.this.getDataObject()).getBundleStructure();
        }
    }
}

