/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PerfData {
    public static final Logger LOG = Logger.getLogger(PerfData.class.getName());
    public static PerfData global = new PerfData();
    private Map<Integer, Long> parserPhaseTime = new TreeMap<Integer, Long>();
    private Map<String, Long> perfCounters = new TreeMap<String, Long>();
    private Map<Integer, Map<String, Long>> visitorCounters = new TreeMap<Integer, Map<String, Long>>();
    private int fileCount;
    private PerfData collector = global;
    private static ThreadLocal<PerfData> threadInstance = new ThreadLocal();
    static Map<Class, String> lambdaClassNames = new HashMap<Class, String>();
    private boolean useAvg;

    private static <T extends Throwable> void sneakyThrow(Throwable exception) throws T {
        throw exception;
    }

    public static PerfData context() {
        PerfData d = threadInstance.get();
        return d == null ? global : d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withPerfData(PerfData data, Callable<T> c) {
        PerfData old = threadInstance.get();
        try {
            threadInstance.set(data);
            T t = c.call();
            return t;
        }
        catch (Exception ex) {
            PerfData.sneakyThrow(ex);
        }
        finally {
            if (old != null) {
                threadInstance.set(old);
            } else {
                threadInstance.remove();
            }
        }
        return null;
    }

    public void setCollector(PerfData collector) {
        this.collector = collector;
    }

    public void clear() {
        this.parserPhaseTime.clear();
        this.perfCounters.clear();
        this.visitorCounters.clear();
        this.fileCount = 0;
    }

    public void addParserPhase(int phaseId, long time) {
        this.parserPhaseTime.merge(phaseId, time, (a, b) -> a + b);
    }

    public void addVisitorTime(int stage, String visitorKey, long time) {
        this.visitorCounters.computeIfAbsent(stage, s -> new HashMap()).merge(visitorKey, time, (a, b) -> a + b);
    }

    public void addPerfCounter(String id, long time) {
        this.perfCounters.merge(id, time, (a, b) -> a + b);
    }

    public void addPerfStats(PerfData other) {
        ++this.fileCount;
        this.merge(other);
    }

    public void merge(PerfData other) {
        for (Integer i : other.parserPhaseTime.keySet()) {
            this.addParserPhase(i, other.parserPhaseTime.get(i));
        }
        for (String s : other.perfCounters.keySet()) {
            this.addPerfCounter(s, other.perfCounters.get(s));
        }
        for (int i = 1; i <= 9; ++i) {
            Map<String, Long> vc = other.visitorCounters.get(i);
            if (vc == null) continue;
            for (String c : vc.keySet()) {
                this.addVisitorTime(i, c, vc.get(c));
            }
        }
    }

    public static String phaseToString(int phase) {
        String s;
        switch (phase) {
            case 1: {
                s = "initialization";
                break;
            }
            case 2: {
                s = "parsing";
                break;
            }
            case 3: {
                s = "conversion";
                break;
            }
            case 4: {
                s = "semanticAnalysis";
                break;
            }
            case 5: {
                s = "canonicalization";
                break;
            }
            case 6: {
                s = "instructionSelection";
                break;
            }
            case 7: {
                s = "classGeneration";
                break;
            }
            case 8: {
                s = "output";
                break;
            }
            case 9: {
                s = "finalization";
                break;
            }
            default: {
                s = "" + phase;
            }
        }
        return s;
    }

    public void dumpStatsAndMerge() {
        if (this.fileCount == 0) {
            this.fileCount = 1;
        }
        if (this.fileCount > 1) {
            LOG.log(Level.FINER, "File count: {0}", this.fileCount);
        }
        this.useAvg = false;
        this.dumpStats();
        if (this.fileCount > 1) {
            LOG.log(Level.FINER, "\n--- Average counters");
            this.useAvg = true;
            this.dumpStats();
        }
        LOG.log(Level.FINER, "------------------------------------------------\n\n");
        if (this.collector != null) {
            this.collector.addPerfStats(this);
        }
    }

    void dumpStats() {
        int i;
        if (this.parserPhaseTime.isEmpty()) {
            return;
        }
        LOG.finer("Phase times:");
        for (i = 0; i <= 9; ++i) {
            Long d = this.parserPhaseTime.get(i);
            if (d == null) continue;
            LOG.log(Level.FINER, "\t" + PerfData.phaseToString(i) + ":\t" + this.avg(d));
        }
        LOG.log(Level.FINER, "\nPhase - visitor statistics:");
        for (i = 1; i <= 9; ++i) {
            Map<String, Long> vc = this.visitorCounters.get(i);
            if (vc == null || vc.isEmpty()) continue;
            LOG.log(Level.FINER, "Visitors from {0}", PerfData.phaseToString(i));
            ArrayList<String> visitors = new ArrayList<String>(vc.keySet());
            Collections.sort(visitors);
            for (String c : visitors) {
                LOG.log(Level.FINER, "\t{0}:\t{1}", new Object[]{c, this.avg(vc.get(c))});
            }
        }
        LOG.log(Level.FINER, "Performance counters:");
        ArrayList<String> keys = new ArrayList<String>(this.perfCounters.keySet());
        Collections.sort(keys);
        for (String s : keys) {
            LOG.log(Level.FINER, "\t{0}:\t{1}", new Object[]{s, this.avg(this.perfCounters.get(s))});
        }
    }

    private String avg(long time) {
        if (!this.useAvg || this.fileCount < 2) {
            return String.valueOf(time);
        }
        if (time / (long)this.fileCount > 20L) {
            return String.valueOf(time / (long)this.fileCount);
        }
        return String.format("%.2f", Float.valueOf((float)time / (float)this.fileCount));
    }
}

