/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.EventTool;
import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.MouseDriver;
import org.netbeans.jemmy.drivers.SupportiveDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JScrollPaneOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.EmptyVisualizer;
import org.openide.explorer.view.Visualizer;

public class TreeTableOperator
extends JTableOperator {
    private JTreeOperator _tree;

    public TreeTableOperator(JTable view) {
        super(view);
    }

    public TreeTableOperator(ContainerOperator contOper) {
        this(contOper, 0);
    }

    public TreeTableOperator(ContainerOperator contOper, int index) {
        this((JTable)TreeTableOperator.waitComponent((ContainerOperator)contOper, (ComponentChooser)new TreeTableFinder(ComponentSearcher.getTrueChooser((String)"Any TreeTable")), (int)index));
        this.copyEnvironment((Operator)contOper);
    }

    public JTreeOperator tree() {
        if (this._tree == null) {
            this.waitState(new ComponentChooser(){

                public boolean checkComponent(Component comp) {
                    return TreeTableOperator.this.getColumnCount() > 0 && TreeTableOperator.this.getRowCount() > 0;
                }

                public String getDescription() {
                    return "TreeTable contains any rows.";
                }
            });
            Object value = this.getValueAt(0, 0);
            JTree jTree = (JTree)this.getCellRenderer(0, 0).getTableCellRendererComponent((JTable)this.getSource(), value, false, false, 0, 0);
            this._tree = new RenderedTreeOperator(this, jTree);
            this._tree.setVisualizer((Operator.ComponentVisualizer)new EmptyVisualizer());
        }
        this.makeComponentVisible();
        return this._tree;
    }

    public int selectNode(String path) {
        TreePath treePath = this.tree().findPath(path, "|");
        if (!this.tree().isPathSelected(treePath)) {
            this.tree().selectPath(treePath);
        }
        int result = this.tree().getRowForPath(treePath);
        this.scrollToCell(result, 0);
        new EventTool().waitNoEvent(500L);
        return result;
    }

    public void verify() {
        this.tree();
    }

    static {
        DriverManager.setDriver((String)"drivers.mouse", (Object)((Object)new RenderedMouseDriver()), RenderedTreeOperator.class);
    }

    public static class RenderedTreeOperator
    extends JTreeOperator {
        TreeTableOperator oper;

        public RenderedTreeOperator(TreeTableOperator oper, JTree tree) {
            super(tree);
            this.oper = oper;
        }

        public ComponentOperator getRealOperator() {
            return this.oper;
        }

        public JPopupMenu callPopupOnPaths(TreePath[] paths, int mouseButton) {
            this.oper.makeComponentVisible();
            for (int i = 0; i < paths.length; ++i) {
                if (paths[i].getParentPath() == null) continue;
                this.expandPath(paths[i].getParentPath());
            }
            this.selectPaths(paths);
            this.scrollToPath(paths[paths.length - 1]);
            Point point = this.getPointToClick(paths[paths.length - 1]);
            return JPopupMenuOperator.callPopup((Component)this.oper.getSource(), (int)((int)point.getX()), (int)((int)point.getY()), (int)mouseButton);
        }

        public void scrollToPath(TreePath path) {
            this.makeComponentVisible();
            JScrollPane scroll = (JScrollPane)this.getContainer((ComponentChooser)new JScrollPaneOperator.JScrollPaneFinder(ComponentSearcher.getTrueChooser((String)"JScrollPane")));
            if (scroll == null) {
                return;
            }
            JScrollPaneOperator scroller = new JScrollPaneOperator(scroll);
            scroller.copyEnvironment((Operator)this);
            scroller.setVisualizer((Operator.ComponentVisualizer)new EmptyVisualizer());
            Rectangle rect = this.getPathBounds(path);
            if (rect == null) {
                throw new JTreeOperator.NoSuchPathException((JTreeOperator)this, path);
            }
            scroller.scrollToComponentRectangle(this.getRealOperator().getSource(), (int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
        }

        public void expandPath(TreePath treePath) {
            super.expandPath(treePath);
            Visualizer.findNode((Object)treePath.getLastPathComponent()).getChildren().getNodes(true);
        }
    }

    public static class RenderedMouseDriver
    extends SupportiveDriver
    implements MouseDriver {
        public RenderedMouseDriver() {
            super(new Class[]{RenderedTreeOperator.class});
        }

        public void pressMouse(ComponentOperator oper, int x, int y, int mouseButton, int modifiers) {
            this.checkSupported(oper);
            ComponentOperator realOper = ((RenderedTreeOperator)oper).getRealOperator();
            DriverManager.getMouseDriver((ComponentOperator)realOper).pressMouse(realOper, x, y, mouseButton, modifiers);
        }

        public void releaseMouse(ComponentOperator oper, int x, int y, int mouseButton, int modifiers) {
            this.checkSupported(oper);
            ComponentOperator realOper = ((RenderedTreeOperator)oper).getRealOperator();
            DriverManager.getMouseDriver((ComponentOperator)realOper).releaseMouse(realOper, x, y, mouseButton, modifiers);
        }

        public void clickMouse(ComponentOperator oper, int x, int y, int clickCount, int mouseButton, int modifiers, Timeout mouseClick) {
            this.checkSupported(oper);
            ComponentOperator realOper = ((RenderedTreeOperator)oper).getRealOperator();
            DriverManager.getMouseDriver((ComponentOperator)realOper).clickMouse(realOper, x, y, clickCount, mouseButton, modifiers, mouseClick);
        }

        public void moveMouse(ComponentOperator oper, int x, int y) {
            this.checkSupported(oper);
            ComponentOperator realOper = ((RenderedTreeOperator)oper).getRealOperator();
            DriverManager.getMouseDriver((ComponentOperator)realOper).moveMouse(realOper, x, y);
        }

        public void dragMouse(ComponentOperator oper, int x, int y, int mouseButton, int modifiers) {
            this.checkSupported(oper);
            ComponentOperator realOper = ((RenderedTreeOperator)oper).getRealOperator();
            DriverManager.getMouseDriver((ComponentOperator)realOper).dragMouse(realOper, x, y, mouseButton, modifiers);
        }

        public void dragNDrop(ComponentOperator oper, int start_x, int start_y, int end_x, int end_y, int mouseButton, int modifiers, Timeout before, Timeout after) {
            this.checkSupported(oper);
            ComponentOperator realOper = ((RenderedTreeOperator)oper).getRealOperator();
            DriverManager.getMouseDriver((ComponentOperator)realOper).dragNDrop(realOper, start_x, start_y, end_x, end_y, mouseButton, modifiers, before, after);
        }

        public void enterMouse(ComponentOperator oper) {
            this.checkSupported(oper);
            ComponentOperator realOper = ((RenderedTreeOperator)oper).getRealOperator();
            DriverManager.getMouseDriver((ComponentOperator)realOper).enterMouse(realOper);
        }

        public void exitMouse(ComponentOperator oper) {
            this.checkSupported(oper);
            ComponentOperator realOper = ((RenderedTreeOperator)oper).getRealOperator();
            DriverManager.getMouseDriver((ComponentOperator)realOper).exitMouse(realOper);
        }
    }

    static class TreeTableFinder
    implements ComponentChooser {
        ComponentChooser subFinder;

        public TreeTableFinder(ComponentChooser sf) {
            this.subFinder = sf;
        }

        public boolean checkComponent(Component comp) {
            Class<?> cls = comp.getClass();
            do {
                if (!cls.getName().equals("org.openide.explorer.view.TreeTable")) continue;
                return this.subFinder.checkComponent(comp);
            } while ((cls = cls.getSuperclass()) != null);
            return false;
        }

        public String getDescription() {
            return this.subFinder.getDescription();
        }
    }
}

