/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.Scope;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.SourceUtilsEx;
import org.netbeans.modules.refactoring.java.WhereUsedBinaryElement;
import org.netbeans.modules.refactoring.java.WhereUsedElement;
import org.netbeans.modules.refactoring.java.api.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.java.plugins.Bundle;
import org.netbeans.modules.refactoring.java.plugins.FindOverridingVisitor;
import org.netbeans.modules.refactoring.java.plugins.FindSubtypesVisitor;
import org.netbeans.modules.refactoring.java.plugins.FindUsagesVisitor;
import org.netbeans.modules.refactoring.java.plugins.FindVisitor;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.JavaWhereUsedFilters;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.ui.FiltersDescription;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class JavaWhereUsedQueryPlugin
extends JavaRefactoringPlugin
implements FiltersDescription.Provider {
    private boolean fromLibrary;
    private final WhereUsedQuery refactoring;
    public static final boolean DEPENDENCIES;
    private volatile CancellableTask queryTask;
    private static final Logger LOG;
    private final EnumSet<JavaWhereUsedFilters.ReadWrite> usedAccessFilters = EnumSet.noneOf(JavaWhereUsedFilters.ReadWrite.class);
    private final Set<String> usedFilters = new HashSet<String>();

    public JavaWhereUsedQueryPlugin(WhereUsedQuery refactoring) {
        this.refactoring = refactoring;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        switch (p) {
            default: 
        }
        return JavaSource.forFileObject((FileObject)((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class)).getFileObject());
    }

    @Override
    public Problem preCheck() {
        this.cancelRequest = false;
        this.cancelRequested.set(false);
        TreePathHandle handle = (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (!handle.getFileObject().isValid()) {
            return new Problem(true, NbBundle.getMessage(FindVisitor.class, (String)"DSC_ElNotAvail"));
        }
        if (handle.getKind() == Tree.Kind.ARRAY_TYPE) {
            return new Problem(true, NbBundle.getMessage(FindVisitor.class, (String)"ERR_FindUsagesArrayType"));
        }
        return super.preCheck();
    }

    @Override
    protected Problem preCheck(CompilationController javac) throws IOException {
        javac.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        TreePathHandle handle = (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (handle.resolveElement((CompilationInfo)javac) == null) {
            return new Problem(true, NbBundle.getMessage(FindVisitor.class, (String)"DSC_ElNotAvail"));
        }
        return null;
    }

    public static Set<FileObject> getRelevantFiles(final TreePathHandle tph, final ClasspathInfo cpInfo, final boolean isFindSubclasses, final boolean isFindDirectSubclassesOnly, final boolean isFindOverridingMethods, final boolean isSearchOverloadedMethods, final boolean isFindUsages, final boolean isIncludeDependencies, final boolean isSearchInComments, Set<NonRecursiveFolder> folders, final AtomicBoolean cancel) {
        final ClassIndex idx = cpInfo.getClassIndex();
        final TreeSet<FileObject> sourceSet = new TreeSet<FileObject>(new FileComparator());
        final Set<Object> packages = folders == null ? Collections.emptySet() : folders;
        final EnumSet<ClassIndex.ResourceType> resourceType = isIncludeDependencies ? EnumSet.of(ClassIndex.ResourceType.SOURCE, ClassIndex.ResourceType.BINARY) : EnumSet.of(ClassIndex.ResourceType.SOURCE);
        final FileObject file = tph.getFileObject();
        JavaSource source = JavaPluginUtils.createSource(file, cpInfo, tph);
        if (cancel != null && cancel.get()) {
            return Collections.emptySet();
        }
        CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            public void run(CompilationController info) throws Exception {
                info.toPhase(JavaSource.Phase.RESOLVED);
                Element el = tph.resolveElement((CompilationInfo)info);
                if (el == null) {
                    sourceSet.clear();
                    LOG.log(Level.INFO, "#250160 #145291: Cannot resolve handle: %s\n%s", new Object[]{tph, info.getClasspathInfo()});
                    return;
                }
                HashSet<1> searchScopeType = new HashSet<1>(1);
                final HashSet<String> packageSet = new HashSet<String>(packages.size());
                for (NonRecursiveFolder nonRecursiveFolder : packages) {
                    String resourceName = cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE).getResourceName(nonRecursiveFolder.getFolder());
                    if (resourceName == null) continue;
                    packageSet.add(resourceName.replace('/', '.'));
                }
                searchScopeType.add(new ClassIndex.SearchScopeType(){

                    public Set<? extends String> getPackages() {
                        return packageSet.isEmpty() ? null : packageSet;
                    }

                    public boolean isSources() {
                        return true;
                    }

                    public boolean isDependencies() {
                        return isIncludeDependencies;
                    }
                });
                if (cancel != null && cancel.get()) {
                    sourceSet.clear();
                    return;
                }
                if (el.getKind().isField()) {
                    ElementHandle handle = ElementHandle.create((Element)((TypeElement)el.getEnclosingElement()));
                    sourceSet.addAll(idx.getResources(handle, EnumSet.of(ClassIndex.SearchKind.FIELD_REFERENCES), searchScopeType, resourceType));
                    if (isSearchInComments && cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE).contains(file)) {
                        sourceSet.add(file);
                    }
                } else if (el.getKind().isClass() || el.getKind().isInterface()) {
                    if (isFindSubclasses || isFindDirectSubclassesOnly) {
                        if (isFindDirectSubclassesOnly) {
                            EnumSet<ClassIndex.SearchKind> searchKind = EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS);
                            if (el.getKind() == ElementKind.INTERFACE) {
                                searchKind.add(ClassIndex.SearchKind.FUNCTIONAL_IMPLEMENTORS);
                            }
                            sourceSet.addAll(idx.getResources(ElementHandle.create((Element)((TypeElement)el)), searchKind, searchScopeType, resourceType));
                        } else {
                            Set<ElementHandle<? extends Element>> implementorsAsHandles = RefactoringUtils.getImplementorsAsHandles(idx, cpInfo, (TypeElement)el, cancel);
                            if (cancel != null && cancel.get()) {
                                sourceSet.clear();
                                return;
                            }
                            sourceSet.addAll(SourceUtilsEx.getFiles(implementorsAsHandles, cpInfo, cancel));
                            if (el.getKind() == ElementKind.INTERFACE) {
                                sourceSet.addAll(JavaWhereUsedQueryPlugin.getFunctionalSubtypes((ElementHandle<TypeElement>)ElementHandle.create((Element)((TypeElement)el)), implementorsAsHandles, cpInfo, searchScopeType));
                            }
                        }
                    } else {
                        sourceSet.addAll(idx.getResources(ElementHandle.create((Element)((TypeElement)el)), EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), searchScopeType, resourceType));
                    }
                } else if (el.getKind() == ElementKind.METHOD) {
                    ExecutableElement method = (ExecutableElement)el;
                    LinkedList<ExecutableElement> methods = new LinkedList<ExecutableElement>();
                    methods.add(method);
                    TypeElement enclosingTypeElement = info.getElementUtilities().enclosingTypeElement((Element)method);
                    if (isSearchOverloadedMethods) {
                        for (Element element : enclosingTypeElement.getEnclosedElements()) {
                            if (method == element || method.getKind() != element.getKind() || !((ExecutableElement)element).getSimpleName().contentEquals(method.getSimpleName())) continue;
                            methods.add((ExecutableElement)element);
                        }
                    }
                    if (isFindOverridingMethods) {
                        sourceSet.addAll(JavaWhereUsedQueryPlugin.getImplementorsRecursive(idx, cpInfo, enclosingTypeElement, cancel));
                    }
                    if (isFindUsages) {
                        Set<ElementHandle<TypeElement>> s = RefactoringUtils.getImplementorsAsHandles(idx, cpInfo, (TypeElement)method.getEnclosingElement(), cancel);
                        for (ElementHandle<TypeElement> eh : s) {
                            if (cancel != null && cancel.get()) {
                                sourceSet.clear();
                                return;
                            }
                            TypeElement te = (TypeElement)eh.resolve((CompilationInfo)info);
                            if (te == null) continue;
                            for (Element element : te.getEnclosedElements()) {
                                if (!RefactoringUtils.isExecutableElement(element)) continue;
                                for (ExecutableElement executableElement : methods) {
                                    if (!info.getElements().overrides((ExecutableElement)element, executableElement, te)) continue;
                                    sourceSet.addAll(idx.getResources(ElementHandle.create((Element)te), EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), searchScopeType, resourceType));
                                }
                            }
                        }
                        sourceSet.addAll(idx.getResources(ElementHandle.create((Element)((TypeElement)el.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), searchScopeType, resourceType));
                    }
                } else if (el.getKind() == ElementKind.CONSTRUCTOR) {
                    sourceSet.addAll(idx.getResources(ElementHandle.create((Element)((TypeElement)el.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), searchScopeType, resourceType));
                } else if (el.getKind().equals((Object)ElementKind.LOCAL_VARIABLE) || el.getKind().equals((Object)ElementKind.PARAMETER) || el.getModifiers().contains((Object)Modifier.PRIVATE)) {
                    sourceSet.add(file);
                }
            }
        };
        try {
            source.runUserActionTask((Task)task, true);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        AbstractSet result = sourceSet;
        if (!isIncludeDependencies) {
            HashSet<FileObject> filteredSources = new HashSet<FileObject>(sourceSet.size());
            ClassPath cp = cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
            for (FileObject fo : sourceSet) {
                if (cp.contains(fo)) {
                    filteredSources.add(fo);
                } else {
                    LOG.log(Level.FINE, "Filtered out: {0}", fo.getNameExt());
                }
                if (cancel == null || !cancel.get()) continue;
                return Collections.emptySet();
            }
            result = filteredSources;
        }
        return result;
    }

    private static Collection<FileObject> getImplementorsRecursive(ClassIndex idx, ClasspathInfo cpInfo, TypeElement el, AtomicBoolean cancel) {
        Set<ElementHandle<? extends Element>> implementorsAsHandles = RefactoringUtils.getImplementorsAsHandles(idx, cpInfo, el, cancel);
        if (cancel != null && cancel.get()) {
            return Collections.emptySet();
        }
        Collection<FileObject> set = SourceUtilsEx.getFiles(implementorsAsHandles, cpInfo, cancel);
        return set;
    }

    public Problem prepare(RefactoringElementsBag elements) {
        Scope customScope;
        this.fireProgressListenerStart(1, -1);
        this.usedAccessFilters.clear();
        this.usedFilters.clear();
        FindTask findTask = new FindTask(elements);
        Problem problem = null;
        ClasspathInfo cp = this.getClasspathInfo((AbstractRefactoring)this.refactoring);
        boolean bl = this.fromLibrary = ((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class)).getFileObject() == null || ((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class)).getFileObject().getNameExt().endsWith("class");
        if (this.isSearchFromBaseClass()) {
            TreePathHandle sourceHandle = (TreePathHandle)this.refactoring.getContext().lookup(TreePathHandle.class);
            cp = this.fromLibrary && sourceHandle != null ? RefactoringUtils.getClasspathInfoFor(sourceHandle, (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class)) : RefactoringUtils.getClasspathInfoFor((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class));
        }
        if ((customScope = (Scope)this.refactoring.getContext().lookup(Scope.class)) != null) {
            if (!customScope.getFiles().isEmpty()) {
                TreeSet<FileObject> a = new TreeSet<FileObject>(new FileComparator());
                a.addAll(customScope.getFiles());
                this.fireProgressListenerStep(a.size());
                try {
                    this.queryFiles(a, findTask, RefactoringUtils.getClasspathInfoFor(a.toArray(new FileObject[a.size()])));
                }
                catch (IOException e) {
                    problem = JavaPluginUtils.chainProblems(problem, this.createProblemAndLog(null, e));
                }
            }
            FileObject fo = null;
            if (this.fromLibrary && (fo = RefactoringUtils.getFileObject((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class))) == null) {
                fo = ((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class)).getFileObject();
            }
            if (!customScope.getSourceRoots().isEmpty()) {
                ClasspathInfo cpath;
                if (this.isSearchFromBaseClass() && fo != null) {
                    HashSet<FileObject> fileobjects = new HashSet<FileObject>(customScope.getSourceRoots());
                    fileobjects.add(fo);
                    cpath = RefactoringUtils.getClasspathInfoFor(customScope.isDependencies(), fileobjects.toArray(new FileObject[0]));
                } else {
                    cpath = RefactoringUtils.getClasspathInfoFor(customScope.isDependencies(), customScope.getSourceRoots().toArray(new FileObject[0]));
                }
                Set<FileObject> a = JavaWhereUsedQueryPlugin.getRelevantFiles((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class), cpath, this.isFindSubclasses(), this.isFindDirectSubclassesOnly(), this.isFindOverridingMethods(), this.isSearchOverloadedMethods(), this.isFindUsages(), customScope.isDependencies(), this.isSearchInComments(), null, this.cancelRequested);
                this.fireProgressListenerStep(a.size());
                try {
                    this.queryFiles(a, findTask, cpath);
                }
                catch (IOException iOException) {
                    problem = JavaPluginUtils.chainProblems(problem, this.createProblemAndLog(null, iOException));
                }
            }
            HashMap<FileObject, HashSet<NonRecursiveFolder>> folders = new HashMap<FileObject, HashSet<NonRecursiveFolder>>();
            for (NonRecursiveFolder nonRecursiveFolder : customScope.getFolders()) {
                FileObject folder = nonRecursiveFolder.getFolder();
                ClassPath classPath = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
                FileObject sourceRoot = classPath.findOwnerRoot(folder);
                HashSet<NonRecursiveFolder> packages = (HashSet<NonRecursiveFolder>)folders.get(sourceRoot);
                if (packages == null) {
                    packages = new HashSet<NonRecursiveFolder>();
                    folders.put(sourceRoot, packages);
                }
                packages.add(nonRecursiveFolder);
            }
            for (Map.Entry entry : folders.entrySet()) {
                FileObject sourceRoot1 = (FileObject)entry.getKey();
                Set packages1 = (Set)entry.getValue();
                if (packages1 == null || packages1.isEmpty()) continue;
                ClasspathInfo cpath = this.isSearchFromBaseClass() && fo != null ? RefactoringUtils.getClasspathInfoFor(customScope.isDependencies(), sourceRoot1, fo) : RefactoringUtils.getClasspathInfoFor(customScope.isDependencies(), sourceRoot1);
                Set<FileObject> a = JavaWhereUsedQueryPlugin.getRelevantFiles((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class), cpath, this.isFindSubclasses(), this.isFindDirectSubclassesOnly(), this.isFindOverridingMethods(), this.isSearchOverloadedMethods(), this.isFindUsages(), customScope.isDependencies(), this.isSearchInComments(), packages1, this.cancelRequested);
                this.fireProgressListenerStep(a.size());
                try {
                    this.queryFiles(a, findTask, cpath);
                }
                catch (IOException e) {
                    problem = JavaPluginUtils.chainProblems(problem, this.createProblemAndLog(null, e));
                }
            }
        } else {
            Set<FileObject> a = JavaWhereUsedQueryPlugin.getRelevantFiles((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class), cp, this.isFindSubclasses(), this.isFindDirectSubclassesOnly(), this.isFindOverridingMethods(), this.isSearchOverloadedMethods(), this.isFindUsages(), false, this.isSearchInComments(), null, this.cancelRequested);
            this.fireProgressListenerStep(a.size());
            try {
                this.queryFiles(a, findTask, cp);
            }
            catch (IOException e) {
                problem = JavaPluginUtils.chainProblems(problem, this.createProblemAndLog(null, e));
            }
        }
        this.fireProgressListenerStop();
        return problem;
    }

    @Override
    public void cancelRequest() {
        super.cancelRequest();
        CancellableTask t = this.queryTask;
        if (t != null) {
            t.cancel();
        }
    }

    @Override
    public Problem fastCheckParameters() {
        if (((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class)).getKind() == Tree.Kind.METHOD) {
            return this.checkParametersForMethod(this.isFindOverridingMethods(), this.isFindUsages());
        }
        return null;
    }

    @Override
    protected Problem checkParameters(CompilationController javac) throws IOException {
        return this.preCheck(javac);
    }

    private Problem checkParametersForMethod(boolean overriders, boolean usages) {
        if (!usages && !overriders) {
            return new Problem(true, NbBundle.getMessage(JavaWhereUsedQueryPlugin.class, (String)"MSG_NothingToFind"));
        }
        return null;
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dob) {
        Object obj = dob.getLookup().lookup(OpenCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        obj = dob.getLookup().lookup(EditorCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        return null;
    }

    private boolean isFindSubclasses() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES);
    }

    private boolean isFindUsages() {
        return this.refactoring.getBooleanValue((Object)"FIND_REFERENCES");
    }

    private boolean isFindDirectSubclassesOnly() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES);
    }

    private boolean isFindOverridingMethods() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS);
    }

    private boolean isSearchOverloadedMethods() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.SEARCH_OVERLOADED);
    }

    private boolean isSearchInComments() {
        return this.refactoring.getBooleanValue((Object)"SEARCH_IN_COMMENTS");
    }

    private boolean isSearchFromBaseClass() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.SEARCH_FROM_BASECLASS);
    }

    public void addFilters(FiltersDescription filtersDescription) {
        filtersDescription.addFilter(JavaWhereUsedFilters.ReadWrite.READ.getKey(), Bundle.READ_FILTER(), true, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/found_item_read.png", (boolean)false));
        filtersDescription.addFilter(JavaWhereUsedFilters.ReadWrite.WRITE.getKey(), Bundle.WRITE_FILTER(), true, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/found_item_write.png", (boolean)false));
        filtersDescription.addFilter(JavaWhereUsedFilters.ReadWrite.READ_WRITE.getKey(), Bundle.READ_WRITE_FILTER(), true, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/found_item_readwrite.png", (boolean)false));
        filtersDescription.addFilter(JavaWhereUsedFilters.IMPORT.getKey(), Bundle.IMPORT_FILTER(), true, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/found_item_import.png", (boolean)false));
        filtersDescription.addFilter(JavaWhereUsedFilters.COMMENT.getKey(), Bundle.COMMENT_FILTER(), true, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/found_item_comment.png", (boolean)false));
        filtersDescription.addFilter(JavaWhereUsedFilters.SOURCEFILE.getKey(), Bundle.SOURCE_FILTER(), true, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/found_item_source.png", (boolean)false));
        if (DEPENDENCIES) {
            filtersDescription.addFilter(JavaWhereUsedFilters.BINARYFILE.getKey(), Bundle.BINARY_FILTER(), true, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/clazz.png", (boolean)false));
        }
        filtersDescription.addFilter(JavaWhereUsedFilters.TESTFILE.getKey(), Bundle.TEST_FILTER(), true, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/found_item_test.png", (boolean)false));
        if (DEPENDENCIES) {
            filtersDescription.addFilter(JavaWhereUsedFilters.DEPENDENCY.getKey(), Bundle.DEPENDENCY_FILTER(), true, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/java/resources/found_item_binary.gif", (boolean)false));
            filtersDescription.addFilter(JavaWhereUsedFilters.PLATFORM.getKey(), Bundle.PLATFORM_FILTER(), true, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/platform/resources/platform.gif", (boolean)false));
        }
    }

    public void enableFilters(FiltersDescription filtersDescription) {
        for (JavaWhereUsedFilters.ReadWrite filter : this.usedAccessFilters) {
            filtersDescription.enable(filter.getKey());
        }
        for (String string : this.usedFilters) {
            filtersDescription.enable(string);
        }
    }

    @NonNull
    private static Collection<? extends FileObject> getFunctionalSubtypes(@NonNull ElementHandle<TypeElement> base, @NonNull Collection<ElementHandle<TypeElement>> subtypes, @NonNull ClasspathInfo cpInfo, @NonNull Set<ClassIndex.SearchScopeType> scope) {
        assert (base.getKind() == ElementKind.INTERFACE);
        ClassIndex index = cpInfo.getClassIndex();
        EnumSet<ClassIndex.SearchKind> fncKind = EnumSet.of(ClassIndex.SearchKind.FUNCTIONAL_IMPLEMENTORS);
        HashSet result = new HashSet();
        result.addAll(index.getResources(base, fncKind, scope));
        for (ElementHandle<TypeElement> e : subtypes) {
            if (e.getKind() != ElementKind.INTERFACE) continue;
            result.addAll(index.getResources(e, fncKind, scope));
        }
        return result;
    }

    static {
        String prop = System.getProperty("org.netbeans.modules.refactoring.java.plugins.JavaWhereUsedQueryPlugin.dependencies");
        DEPENDENCIES = prop == null ? true : prop.equalsIgnoreCase("true");
        LOG = Logger.getLogger(JavaWhereUsedQueryPlugin.class.getName());
    }

    private static class FileComparator
    implements Comparator<FileObject> {
        private FileComparator() {
        }

        @Override
        public int compare(FileObject o1, FileObject o2) {
            return o1.getPath().compareTo(o2.getPath());
        }
    }

    private class FindTask
    implements CancellableTask<CompilationController> {
        private final RefactoringElementsBag elements;
        private volatile AtomicBoolean cancelled;
        private final Set<FileObject> cachedPlatformRoots;

        public FindTask(RefactoringElementsBag elements) {
            this.elements = elements;
            this.cancelled = new AtomicBoolean(false);
            this.cachedPlatformRoots = new HashSet<FileObject>();
        }

        public void cancel() {
            this.cancelled.set(true);
        }

        public void run(CompilationController compiler) throws IOException {
            boolean fromTest;
            boolean fromDependency;
            if (this.cancelled.get()) {
                return;
            }
            if (compiler.toPhase(JavaSource.Phase.RESOLVED) != JavaSource.Phase.RESOLVED) {
                return;
            }
            TreePathHandle handle = (TreePathHandle)JavaWhereUsedQueryPlugin.this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
            Element element = handle.resolveElement((CompilationInfo)compiler);
            if (element == null) {
                ErrorManager.getDefault().log(65536, "element is null for handle " + handle);
                return;
            }
            CompilationUnitTree cu = compiler.getCompilationUnit();
            FileObject fo = compiler.getFileObject();
            boolean fromPlatform = this.fromPlatform(fo);
            if (cu == null) {
                if (DEPENDENCIES) {
                    boolean fromTest2 = false;
                    this.elements.add((AbstractRefactoring)JavaWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedBinaryElement.create(fo, fromTest2, fromPlatform));
                    JavaWhereUsedQueryPlugin.this.usedFilters.add(JavaWhereUsedFilters.BINARYFILE.getKey());
                }
                return;
            }
            if (!fromPlatform) {
                ClassPath srcPath = compiler.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
                FileObject ownerRoot = srcPath.findOwnerRoot(fo);
                fromDependency = ownerRoot == null;
                fromTest = !fromDependency && RefactoringUtils.isFromTestRoot(fo, srcPath);
            } else {
                fromTest = false;
                fromDependency = false;
            }
            AtomicBoolean inImport = new AtomicBoolean();
            if (JavaWhereUsedQueryPlugin.this.isFindUsages()) {
                FindUsagesVisitor findVisitor = new FindUsagesVisitor(compiler, this.cancelled, JavaWhereUsedQueryPlugin.this.isSearchInComments(), JavaWhereUsedQueryPlugin.this.isSearchOverloadedMethods(), fromTest, fromPlatform, fromDependency, inImport);
                findVisitor.scan(cu, element);
                Collection<WhereUsedElement> foundElements = findVisitor.getElements();
                boolean usagesInComments = findVisitor.usagesInComments();
                for (WhereUsedElement el : foundElements) {
                    JavaWhereUsedFilters.ReadWrite access = el.getAccess();
                    if (access != null) {
                        JavaWhereUsedQueryPlugin.this.usedAccessFilters.add(access);
                    }
                    this.elements.add((AbstractRefactoring)JavaWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)el);
                }
                if (!foundElements.isEmpty()) {
                    if (fromTest) {
                        JavaWhereUsedQueryPlugin.this.usedFilters.add(JavaWhereUsedFilters.TESTFILE.getKey());
                    }
                    if (!fromTest) {
                        JavaWhereUsedQueryPlugin.this.usedFilters.add(JavaWhereUsedFilters.SOURCEFILE.getKey());
                    }
                    if (usagesInComments) {
                        JavaWhereUsedQueryPlugin.this.usedFilters.add(JavaWhereUsedFilters.COMMENT.getKey());
                    }
                    if (inImport.get()) {
                        JavaWhereUsedQueryPlugin.this.usedFilters.add(JavaWhereUsedFilters.IMPORT.getKey());
                    }
                    if (DEPENDENCIES) {
                        if (fromDependency) {
                            JavaWhereUsedQueryPlugin.this.usedFilters.add(JavaWhereUsedFilters.DEPENDENCY.getKey());
                        }
                        if (fromPlatform) {
                            JavaWhereUsedQueryPlugin.this.usedFilters.add(JavaWhereUsedFilters.PLATFORM.getKey());
                        }
                    }
                }
            }
            ArrayList<TreePath> result = new ArrayList<TreePath>();
            if (element.getKind() == ElementKind.METHOD && JavaWhereUsedQueryPlugin.this.isFindOverridingMethods()) {
                FindOverridingVisitor override = new FindOverridingVisitor(compiler);
                override.scan(compiler.getCompilationUnit(), element);
                result.addAll(override.getUsages());
            } else if ((element.getKind().isClass() || element.getKind().isInterface()) && (JavaWhereUsedQueryPlugin.this.isFindSubclasses() || JavaWhereUsedQueryPlugin.this.isFindDirectSubclassesOnly())) {
                FindSubtypesVisitor subtypes = new FindSubtypesVisitor(!JavaWhereUsedQueryPlugin.this.isFindDirectSubclassesOnly(), compiler);
                subtypes.scan(compiler.getCompilationUnit(), element);
                result.addAll(subtypes.getUsages());
            }
            for (TreePath tree : result) {
                this.elements.add((AbstractRefactoring)JavaWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create((CompilationInfo)compiler, tree, fromTest, fromPlatform, fromDependency, inImport));
            }
            if (!result.isEmpty()) {
                if (DEPENDENCIES) {
                    if (fromPlatform) {
                        JavaWhereUsedQueryPlugin.this.usedFilters.add(JavaWhereUsedFilters.PLATFORM.getKey());
                    }
                    if (fromDependency) {
                        JavaWhereUsedQueryPlugin.this.usedFilters.add(JavaWhereUsedFilters.DEPENDENCY.getKey());
                    }
                }
                if (fromTest) {
                    JavaWhereUsedQueryPlugin.this.usedFilters.add(JavaWhereUsedFilters.TESTFILE.getKey());
                }
                if (!fromTest) {
                    JavaWhereUsedQueryPlugin.this.usedFilters.add(JavaWhereUsedFilters.SOURCEFILE.getKey());
                }
                if (inImport.get()) {
                    JavaWhereUsedQueryPlugin.this.usedFilters.add(JavaWhereUsedFilters.IMPORT.getKey());
                }
            }
            JavaWhereUsedQueryPlugin.this.fireProgressListenerStep();
        }

        private boolean fromPlatform(FileObject fo) {
            FileObject root;
            boolean fromPlatform = false;
            FileObject archive = FileUtil.getArchiveFile((FileObject)fo);
            if (archive != null && (root = FileUtil.getArchiveRoot((FileObject)archive)) != null) {
                if (this.cachedPlatformRoots.contains(root)) {
                    fromPlatform = true;
                }
                JavaPlatformManager manager = JavaPlatformManager.getDefault();
                for (JavaPlatform javaPlatform : manager.getInstalledPlatforms()) {
                    if (!javaPlatform.getSourceFolders().contains(root) && !javaPlatform.getStandardLibraries().contains(root) && !javaPlatform.getBootstrapLibraries().contains(root)) continue;
                    fromPlatform = true;
                    if (DEPENDENCIES) {
                        JavaWhereUsedQueryPlugin.this.usedFilters.add(JavaWhereUsedFilters.PLATFORM.getKey());
                    }
                    this.cachedPlatformRoots.add(root);
                    break;
                }
            }
            return fromPlatform;
        }
    }
}

