/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.servlet.ServletInputStream;
import org.apache.tomcat.core.BufferedServletInputStream;
import org.apache.tomcat.core.RequestImpl;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.util.MimeHeaderField;
import org.apache.tomcat.util.MimeHeaders;
import org.apache.tomcat.util.RecycleBufferedInputStream;
import org.apache.tomcat.util.StringManager;

public class HttpRequestAdapter
extends RequestImpl {
    private static StringManager sm1 = StringManager.getManager("org.apache.tomcat.util");
    private Socket socket;
    private boolean moreRequests = false;
    RecycleBufferedInputStream sin;
    byte[] buf = new byte[this.bufSize];
    int bufSize = 2048;
    int off = 0;
    int count = 0;
    public static final String DEFAULT_CHARACTER_ENCODING = "8859_1";

    public void setSocket(Socket socket) throws IOException {
        if (this.sin == null) {
            this.sin = new RecycleBufferedInputStream(socket.getInputStream());
        } else {
            this.sin.setInputStream(socket.getInputStream());
        }
        this.in = new BufferedServletInputStream(this);
        this.socket = socket;
        this.moreRequests = true;
    }

    public void recycle() {
        super.recycle();
        this.off = 0;
        this.count = 0;
        if (this.sin != null) {
            this.sin.recycle();
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public boolean hasMoreRequests() {
        return this.moreRequests;
    }

    public int doRead() throws IOException {
        return this.sin.read();
    }

    public int doRead(byte[] b, int off, int len) throws IOException {
        return this.sin.read(b, off, len);
    }

    public void readNextRequest(Response response) throws IOException {
        this.count = this.in.readLine(this.buf, 0, this.buf.length);
        if (this.count < 0) {
            response.setStatus(400);
            return;
        }
        this.processRequestLine(response);
        if (this.protocol != null) {
            this.readHeaders(this.headers, this.in);
        }
        this.moreRequests = false;
    }

    public void readHeaders(MimeHeaders headers, ServletInputStream in) throws IOException {
        block4: {
            int start;
            MimeHeaderField mhf;
            this.off = this.count;
            do {
                start = this.off;
                while (true) {
                    int len;
                    if ((len = this.buf.length - this.off) > 0 && (len = in.readLine(this.buf, this.off, len)) == -1) {
                        String msg = sm1.getString("mimeHeader.connection.ioe");
                        throw new IOException(msg);
                    }
                    this.off += len;
                    if (len == 0 || this.buf[this.off - 1] == 10) break;
                    byte[] tmp = new byte[this.buf.length * 2];
                    System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
                    this.buf = tmp;
                }
                if (--this.off > start && this.buf[this.off - 1] == 13) {
                    --this.off;
                }
                if (this.off == start) break block4;
            } while (this.parseHeaderFiled(mhf = headers.putHeader(), this.buf, start, this.off - start));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean parseHeaderFiled(MimeHeaderField mhf, byte[] b, int off, int len) {
        byte c;
        int start = off;
        while ((c = b[off++]) != 58 && c != 32) {
            void var6_6;
            if (var6_6 != 10) continue;
            System.out.println("Parse error, empty line: " + new String(b, off, len));
            return false;
        }
        mhf.setName(b, start, off - start - 1);
        while (c == 32) {
            c = b[off++];
        }
        if (c != 58) {
            System.out.println("Parse error, missing : in  " + new String(b, off, len));
            System.out.println("Full  " + new String(b, 0, b.length));
            return false;
        }
        while ((c = b[off++]) == 32) {
        }
        mhf.setValue(b, off - 1, len - (off - start - 1));
        return true;
    }

    public int getServerPort() {
        if (this.serverPort != -1) {
            return this.serverPort;
        }
        String hostHeader = this.getHeader("host");
        if (hostHeader == null) {
            this.serverPort = this.socket.getLocalPort();
        } else {
            int i = hostHeader.indexOf(58);
            if (i > -1) {
                hostHeader = hostHeader.substring(i + 1);
                try {
                    this.serverPort = Integer.parseInt(hostHeader);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                this.serverPort = this.isSecure() ? 443 : 80;
            }
        }
        return this.serverPort;
    }

    public String getServerName() {
        if (this.serverName != null) {
            return this.serverName;
        }
        String hostHeader = this.getHeader("host");
        if (hostHeader != null) {
            int i = hostHeader.indexOf(58);
            if (i > -1) {
                hostHeader = hostHeader.substring(0, i);
            }
            this.serverName = hostHeader;
            return this.serverName;
        }
        if (hostHeader == null) {
            InetAddress localAddress = this.socket.getLocalAddress();
            this.serverName = localAddress.getHostName();
        }
        return this.serverName;
    }

    public String getRemoteAddr() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public String getRemoteHost() {
        return this.socket.getInetAddress().getHostName();
    }

    private final int skipSpaces() {
        while (this.off < this.count) {
            if (this.buf[this.off] != 32 && this.buf[this.off] != 9 && this.buf[this.off] != 13 && this.buf[this.off] != 10) {
                return this.off;
            }
            ++this.off;
        }
        return -1;
    }

    private int findSpace() {
        while (this.off < this.count) {
            if (this.buf[this.off] == 32 || this.buf[this.off] == 9 || this.buf[this.off] == 13 || this.buf[this.off] == 10) {
                return this.off;
            }
            ++this.off;
        }
        return -1;
    }

    private int findChar(char c, int start, int end) {
        byte b = (byte)c;
        int offset = start;
        while (offset < end) {
            if (this.buf[offset] == b) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    private void processRequestLine(Response response) throws IOException {
        this.off = 0;
        if (this.buf[this.count - 1] != 13 && this.buf[this.count - 1] != 10) {
            response.setStatus(414);
            return;
        }
        int startMethod = this.skipSpaces();
        int endMethod = this.findSpace();
        int startReq = this.skipSpaces();
        int endReq = this.findSpace();
        int startProto = this.skipSpaces();
        int endProto = this.findSpace();
        if (startReq < 0) {
            response.setStatus(400);
            this.protocol = null;
            return;
        }
        this.method = new String(this.buf, startMethod, endMethod - startMethod);
        if (startProto < 0) {
            this.protocol = null;
        } else {
            if (endProto < 0) {
                endProto = this.count;
            }
            this.protocol = new String(this.buf, startProto, endProto - startProto);
        }
        int qryIdx = this.findChar('?', startReq, endReq);
        if (qryIdx < 0) {
            this.requestURI = new String(this.buf, startReq, endReq - startReq);
        } else {
            this.requestURI = new String(this.buf, startReq, qryIdx - startReq);
            this.queryString = new String(this.buf, qryIdx + 1, endReq - qryIdx - 1);
        }
    }
}

